/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api.services;

import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IObjectArray;

/**
 * オーディオエフェクト用のエフェクトコンテキストです。
 */
public interface IAudioEffectContext extends IEffectContext {

	/**
	 * 引数 avalue の現在時刻からの値を、エフェクトコンテキストのサンプルフレーム数と同じ数だけ取得します。
	 * 
	 * @param avalue {@link ch.kuramo.javie.api.IAnimatableDouble} などのアニメーション可能プロパティ
	 * @return 引数 avalue の現在時刻からの値の配列をラップした <code>IObjectArray</code> オブジェクト
	 */
	<V> IObjectArray<V> values(IAnimatableValue<V> avalue);

	/**
	 * @deprecated このメソッドは、将来、変更または廃止される可能性があります。
	 */
	@Deprecated
	<V> IObjectArray<V> values(IAnimatableValue<V> avalue, int animationRate);

	/**
	 * ひとつ前のオーディオエフェクトまで処理を実行します。
	 * 
	 * @return ひとつ前のオーディオエフェクトまで処理を実行した結果のオーディオデータ
	 */
	IAudioBuffer doPreviousEffect();

}
