/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.awt;

import com.sun.nativewindow.impl.Debug;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsScreen;

public class AWTGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    private GraphicsConfiguration config;
    AbstractGraphicsConfiguration encapsulated;

    public AWTGraphicsConfiguration(AWTGraphicsScreen aWTGraphicsScreen, Capabilities capabilities, Capabilities capabilities2, GraphicsConfiguration graphicsConfiguration, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(aWTGraphicsScreen, capabilities, capabilities2);
        this.config = graphicsConfiguration;
        this.encapsulated = abstractGraphicsConfiguration;
    }

    public AWTGraphicsConfiguration(AWTGraphicsScreen aWTGraphicsScreen, Capabilities capabilities, Capabilities capabilities2, GraphicsConfiguration graphicsConfiguration) {
        super(aWTGraphicsScreen, capabilities, capabilities2);
        this.config = graphicsConfiguration;
        this.encapsulated = null;
    }

    public Object clone() {
        return super.clone();
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public AbstractGraphicsConfiguration getNativeGraphicsConfiguration() {
        return null != this.encapsulated ? this.encapsulated : this;
    }

    public static Capabilities setupCapabilitiesRGBABits(Capabilities capabilities, GraphicsConfiguration graphicsConfiguration) {
        int n = capabilities.isBackgroundOpaque() ? 1 : 3;
        ColorModel colorModel = graphicsConfiguration.getColorModel(n);
        if (null == colorModel && !capabilities.isBackgroundOpaque()) {
            capabilities.setBackgroundOpaque(true);
            n = 1;
            colorModel = graphicsConfiguration.getColorModel(n);
        }
        if (null == colorModel) {
            throw new NativeWindowException("Could not determine AWT ColorModel");
        }
        int n2 = colorModel.getPixelSize();
        int n3 = 0;
        int[] nArray = colorModel.getComponentSize();
        if (nArray.length >= 3) {
            capabilities.setRedBits(nArray[0]);
            n3 += nArray[0];
            capabilities.setGreenBits(nArray[1]);
            n3 += nArray[1];
            capabilities.setBlueBits(nArray[2]);
            n3 += nArray[2];
        }
        if (nArray.length >= 4) {
            capabilities.setAlphaBits(nArray[3]);
            n3 += nArray[3];
        } else {
            capabilities.setAlphaBits(0);
        }
        if (Debug.debugAll() && n2 != n3) {
            System.err.println("AWT Colormodel bits per components/pixel mismatch: " + n3 + " != " + n2);
        }
        return capabilities;
    }

    public String toString() {
        return this.getClass().toString() + "[" + this.getScreen() + ",\n\tchosen    " + this.capabilitiesChosen + ",\n\trequested " + this.capabilitiesRequested + ",\n\t" + this.config + ",\n\tencapsulated " + this.encapsulated + "]";
    }
}

