/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.glu;

import com.sun.opengl.util.ImmModeSink;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public class GLUquadricImpl
implements GLUquadric {
    private boolean useGLSL;
    private int drawStyle;
    private int orientation;
    private boolean textureFlag;
    private int normals;
    private boolean immModeSinkEnabled;
    private boolean immModeSinkImmediate;
    public int normalType;
    public GL gl;
    public static final boolean USE_NORM = true;
    public static final boolean USE_TEXT = false;
    private ImmModeSink immModeSink = null;
    private static final float PI = (float)Math.PI;
    private static final int CACHE_SIZE = 240;

    public GLUquadricImpl(GL gL, boolean bl) {
        this.gl = gL;
        this.useGLSL = bl;
        this.drawStyle = 100012;
        this.orientation = 100020;
        this.textureFlag = false;
        this.normals = 100000;
        this.normalType = gL.isGLES1() ? 5120 : 5126;
        this.immModeSinkImmediate = true;
        this.immModeSinkEnabled = !gL.isGL2();
        this.replaceImmModeSink();
    }

    public void enableImmModeSink(boolean bl) {
        this.immModeSinkEnabled = this.gl.isGL2() ? bl : true;
        if (null == this.immModeSink && this.immModeSinkEnabled) {
            this.replaceImmModeSink();
        }
    }

    public boolean isImmModeSinkEnabled() {
        return this.immModeSinkEnabled;
    }

    public void setImmMode(boolean bl) {
        this.immModeSinkImmediate = this.immModeSinkEnabled ? bl : true;
    }

    public boolean getImmMode() {
        return this.immModeSinkImmediate;
    }

    public ImmModeSink replaceImmModeSink() {
        if (!this.immModeSinkEnabled) {
            return null;
        }
        ImmModeSink immModeSink = this.immModeSink;
        this.immModeSink = this.useGLSL ? ImmModeSink.createGLSL(this.gl, 35044, 32, 3, 5126, 0, 5126, 3, this.normalType, 0, 5126) : ImmModeSink.createFixed(this.gl, 35044, 32, 3, 5126, 0, 5126, 3, this.normalType, 0, 5126);
        return immModeSink;
    }

    public void resetImmModeSink(GL gL) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.reset(gL);
        }
    }

    public void setDrawStyle(int n) {
        this.drawStyle = n;
    }

    public void setNormals(int n) {
        this.normals = n;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setTextureFlag(boolean bl) {
        this.textureFlag = bl;
    }

    public int getDrawStyle() {
        return this.drawStyle;
    }

    public int getNormals() {
        return this.normals;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getTextureFlag() {
        return this.textureFlag;
    }

    public void drawCylinder(GL gL, float f, float f2, float f3, int n, int n2) {
        float f4 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f5 = (float)Math.PI * 2 / (float)n;
        float f6 = (f2 - f) / (float)n2;
        float f7 = f3 / (float)n2;
        float f8 = (f - f2) / f3;
        if (this.drawStyle == 100010) {
            this.glBegin(gL, 0);
            for (int i = 0; i < n; ++i) {
                float f9 = this.cos((float)i * f5);
                float f10 = this.sin((float)i * f5);
                this.normal3f(gL, f9 * f4, f10 * f4, f8 * f4);
                float f11 = 0.0f;
                float f12 = f;
                for (int j = 0; j <= n2; ++j) {
                    this.glVertex3f(gL, f9 * f12, f10 * f12, f11);
                    f11 += f7;
                    f12 += f6;
                }
            }
            this.glEnd(gL);
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f13;
            float f14;
            int n3;
            if (this.drawStyle == 100011) {
                float f15 = 0.0f;
                float f16 = f;
                for (int i = 0; i <= n2; ++i) {
                    this.glBegin(gL, 2);
                    for (n3 = 0; n3 < n; ++n3) {
                        f14 = this.cos((float)n3 * f5);
                        f13 = this.sin((float)n3 * f5);
                        this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                        this.glVertex3f(gL, f14 * f16, f13 * f16, f15);
                    }
                    this.glEnd(gL);
                    f15 += f7;
                    f16 += f6;
                }
            } else if ((double)f != 0.0) {
                this.glBegin(gL, 2);
                for (n3 = 0; n3 < n; ++n3) {
                    f14 = this.cos((float)n3 * f5);
                    f13 = this.sin((float)n3 * f5);
                    this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                    this.glVertex3f(gL, f14 * f, f13 * f, 0.0f);
                }
                this.glEnd(gL);
                this.glBegin(gL, 2);
                for (n3 = 0; n3 < n; ++n3) {
                    f14 = this.cos((float)n3 * f5);
                    f13 = this.sin((float)n3 * f5);
                    this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                    this.glVertex3f(gL, f14 * f2, f13 * f2, f3);
                }
                this.glEnd(gL);
            }
            this.glBegin(gL, 1);
            for (n3 = 0; n3 < n; ++n3) {
                f14 = this.cos((float)n3 * f5);
                f13 = this.sin((float)n3 * f5);
                this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                this.glVertex3f(gL, f14 * f, f13 * f, 0.0f);
                this.glVertex3f(gL, f14 * f2, f13 * f2, f3);
            }
            this.glEnd(gL);
        } else if (this.drawStyle == 100012) {
            float f17 = 1.0f / (float)n;
            float f18 = 1.0f / (float)n2;
            float f19 = 0.0f;
            float f20 = 0.0f;
            float f21 = f;
            for (int i = 0; i < n2; ++i) {
                float f22 = 0.0f;
                this.glBegin(gL, 8);
                for (int j = 0; j <= n; ++j) {
                    float f23;
                    float f24;
                    if (j == n) {
                        f24 = this.sin(0.0f);
                        f23 = this.cos(0.0f);
                    } else {
                        f24 = this.sin((float)j * f5);
                        f23 = this.cos((float)j * f5);
                    }
                    if (f4 == 1.0f) {
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19);
                        this.glVertex3f(gL, f24 * f21, f23 * f21, f20);
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19 + f18);
                        this.glVertex3f(gL, f24 * (f21 + f6), f23 * (f21 + f6), f20 + f7);
                    } else {
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19);
                        this.glVertex3f(gL, f24 * f21, f23 * f21, f20);
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19 + f18);
                        this.glVertex3f(gL, f24 * (f21 + f6), f23 * (f21 + f6), f20 + f7);
                    }
                    f22 += f17;
                }
                this.glEnd(gL);
                f21 += f6;
                f19 += f18;
                f20 += f7;
            }
        }
    }

    public void drawDisk(GL gL, float f, float f2, int n, int n2) {
        if (this.normals != 100002) {
            if (this.orientation == 100020) {
                this.glNormal3f(gL, 0.0f, 0.0f, 1.0f);
            } else {
                this.glNormal3f(gL, 0.0f, 0.0f, -1.0f);
            }
        }
        float f3 = (float)Math.PI * 2 / (float)n;
        float f4 = (f2 - f) / (float)n2;
        switch (this.drawStyle) {
            case 100012: {
                float f5 = 2.0f * f2;
                float f6 = f;
                for (int i = 0; i < n2; ++i) {
                    float f7;
                    float f8;
                    float f9;
                    int n3;
                    float f10 = f6 + f4;
                    if (this.orientation == 100020) {
                        this.glBegin(gL, 8);
                        for (n3 = 0; n3 <= n; ++n3) {
                            f9 = n3 == n ? 0.0f : (float)n3 * f3;
                            f8 = this.sin(f9);
                            f7 = this.cos(f9);
                            this.TXTR_COORD(gL, 0.5f + f8 * f10 / f5, 0.5f + f7 * f10 / f5);
                            this.glVertex2f(gL, f10 * f8, f10 * f7);
                            this.TXTR_COORD(gL, 0.5f + f8 * f6 / f5, 0.5f + f7 * f6 / f5);
                            this.glVertex2f(gL, f6 * f8, f6 * f7);
                        }
                        this.glEnd(gL);
                    } else {
                        this.glBegin(gL, 8);
                        for (n3 = n; n3 >= 0; --n3) {
                            f9 = n3 == n ? 0.0f : (float)n3 * f3;
                            f8 = this.sin(f9);
                            f7 = this.cos(f9);
                            this.TXTR_COORD(gL, 0.5f - f8 * f10 / f5, 0.5f + f7 * f10 / f5);
                            this.glVertex2f(gL, f10 * f8, f10 * f7);
                            this.TXTR_COORD(gL, 0.5f - f8 * f6 / f5, 0.5f + f7 * f6 / f5);
                            this.glVertex2f(gL, f6 * f8, f6 * f7);
                        }
                        this.glEnd(gL);
                    }
                    f6 = f10;
                }
                break;
            }
            case 100011: {
                float f11;
                int n4;
                float f12;
                int n5;
                for (n5 = 0; n5 <= n2; ++n5) {
                    f12 = f + (float)n5 * f4;
                    this.glBegin(gL, 2);
                    for (n4 = 0; n4 < n; ++n4) {
                        f11 = (float)n4 * f3;
                        this.glVertex2f(gL, f12 * this.sin(f11), f12 * this.cos(f11));
                    }
                    this.glEnd(gL);
                }
                for (n4 = 0; n4 < n; ++n4) {
                    f12 = (float)n4 * f3;
                    f11 = this.sin(f12);
                    float f13 = this.cos(f12);
                    this.glBegin(gL, 3);
                    for (n5 = 0; n5 <= n2; ++n5) {
                        float f14 = f + (float)n5 * f4;
                        this.glVertex2f(gL, f14 * f11, f14 * f13);
                    }
                    this.glEnd(gL);
                }
                break;
            }
            case 100010: {
                this.glBegin(gL, 0);
                for (int i = 0; i < n; ++i) {
                    float f15 = (float)i * f3;
                    float f16 = this.sin(f15);
                    float f17 = this.cos(f15);
                    for (int j = 0; j <= n2; ++j) {
                        float f18 = f * (float)j * f4;
                        this.glVertex2f(gL, f18 * f16, f18 * f17);
                    }
                }
                this.glEnd(gL);
                break;
            }
            case 100013: {
                float f19;
                float f20;
                float f21;
                if ((double)f != 0.0) {
                    this.glBegin(gL, 2);
                    f21 = 0.0f;
                    while ((double)f21 < 6.2831854820251465) {
                        f20 = f * this.sin(f21);
                        f19 = f * this.cos(f21);
                        this.glVertex2f(gL, f20, f19);
                        f21 += f3;
                    }
                    this.glEnd(gL);
                }
                this.glBegin(gL, 2);
                for (f21 = 0.0f; f21 < (float)Math.PI * 2; f21 += f3) {
                    f20 = f2 * this.sin(f21);
                    f19 = f2 * this.cos(f21);
                    this.glVertex2f(gL, f20, f19);
                }
                this.glEnd(gL);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void drawPartialDisk(GL gL, float f, float f2, int n, int n2, float f3, float f4) {
        int n3;
        float[] fArray = new float[240];
        float[] fArray2 = new float[240];
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (n >= 240) {
            n = 239;
        }
        if (n < 2 || n2 < 1 || f2 <= 0.0f || f < 0.0f || f > f2) {
            System.err.println("PartialDisk: GLU_INVALID_VALUE");
            return;
        }
        if (f4 < -360.0f) {
            f4 = 360.0f;
        }
        if (f4 > 360.0f) {
            f4 = 360.0f;
        }
        if (f4 < 0.0f) {
            f3 += f4;
            f4 = -f4;
        }
        int n4 = f4 == 360.0f ? n : n + 1;
        float f7 = f2 - f;
        float f8 = f3 / 180.0f * (float)Math.PI;
        for (n3 = 0; n3 <= n; ++n3) {
            float f9 = f8 + (float)Math.PI * f4 / 180.0f * (float)n3 / (float)n;
            fArray[n3] = this.sin(f9);
            fArray2[n3] = this.cos(f9);
        }
        if (f4 == 360.0f) {
            fArray[n] = fArray[0];
            fArray2[n] = fArray2[0];
        }
        switch (this.normals) {
            case 100000: 
            case 100001: {
                if (this.orientation == 100020) {
                    this.glNormal3f(gL, 0.0f, 0.0f, 1.0f);
                    break;
                }
                this.glNormal3f(gL, 0.0f, 0.0f, -1.0f);
                break;
            }
        }
        block3 : switch (this.drawStyle) {
            case 100012: {
                float f10;
                int n5;
                if (f == 0.0f) {
                    n5 = n2 - 1;
                    this.glBegin(gL, 6);
                    if (this.textureFlag) {
                        this.glTexCoord2f(gL, 0.5f, 0.5f);
                    }
                    this.glVertex3f(gL, 0.0f, 0.0f, 0.0f);
                    f10 = f2 - f7 * ((float)(n2 - 1) / (float)n2);
                    if (this.textureFlag) {
                        f5 = f10 / f2 / 2.0f;
                    }
                    if (this.orientation == 100020) {
                        for (n3 = n; n3 >= 0; --n3) {
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            this.glVertex3f(gL, f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                        }
                    } else {
                        for (n3 = 0; n3 <= n; ++n3) {
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            this.glVertex3f(gL, f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                        }
                    }
                    this.glEnd(gL);
                } else {
                    n5 = n2;
                }
                for (int i = 0; i < n5; ++i) {
                    f10 = f2 - f7 * ((float)i / (float)n2);
                    float f11 = f2 - f7 * ((float)(i + 1) / (float)n2);
                    if (this.textureFlag) {
                        f5 = f10 / f2 / 2.0f;
                        f6 = f11 / f2 / 2.0f;
                    }
                    this.glBegin(gL, 8);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.orientation == 100020) {
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            this.glVertex3f(gL, f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f6 * fArray[n3] + 0.5f, f6 * fArray2[n3] + 0.5f);
                            }
                            this.glVertex3f(gL, f11 * fArray[n3], f11 * fArray2[n3], 0.0f);
                            continue;
                        }
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f6 * fArray[n3] + 0.5f, f6 * fArray2[n3] + 0.5f);
                        }
                        this.glVertex3f(gL, f11 * fArray[n3], f11 * fArray2[n3], 0.0f);
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        this.glVertex3f(gL, f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                    }
                    this.glEnd(gL);
                }
                break;
            }
            case 100010: {
                this.glBegin(gL, 0);
                for (n3 = 0; n3 < n4; ++n3) {
                    float f12 = fArray[n3];
                    float f13 = fArray2[n3];
                    for (int i = 0; i <= n2; ++i) {
                        float f14 = f2 - f7 * ((float)i / (float)n2);
                        if (this.textureFlag) {
                            f5 = f14 / f2 / 2.0f;
                            this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        this.glVertex3f(gL, f14 * f12, f14 * f13, 0.0f);
                    }
                }
                this.glEnd(gL);
                break;
            }
            case 100011: {
                float f15;
                int n6;
                if (f == f2) {
                    this.glBegin(gL, 3);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, fArray[n3] / 2.0f + 0.5f, fArray2[n3] / 2.0f + 0.5f);
                        }
                        this.glVertex3f(gL, f * fArray[n3], f * fArray2[n3], 0.0f);
                    }
                    this.glEnd(gL);
                    break;
                }
                for (n6 = 0; n6 <= n2; ++n6) {
                    f15 = f2 - f7 * ((float)n6 / (float)n2);
                    if (this.textureFlag) {
                        f5 = f15 / f2 / 2.0f;
                    }
                    this.glBegin(gL, 3);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        this.glVertex3f(gL, f15 * fArray[n3], f15 * fArray2[n3], 0.0f);
                    }
                    this.glEnd(gL);
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    float f16 = fArray[n3];
                    float f17 = fArray2[n3];
                    this.glBegin(gL, 3);
                    for (n6 = 0; n6 <= n2; ++n6) {
                        f15 = f2 - f7 * ((float)n6 / (float)n2);
                        if (this.textureFlag) {
                            f5 = f15 / f2 / 2.0f;
                        }
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        this.glVertex3f(gL, f15 * f16, f15 * f17, 0.0f);
                    }
                    this.glEnd(gL);
                }
                break;
            }
            case 100013: {
                float f18;
                int n7;
                if (f4 < 360.0f) {
                    for (n3 = 0; n3 <= n; n3 += n) {
                        float f19 = fArray[n3];
                        float f20 = fArray2[n3];
                        this.glBegin(gL, 3);
                        for (n7 = 0; n7 <= n2; ++n7) {
                            f18 = f2 - f7 * ((float)n7 / (float)n2);
                            if (this.textureFlag) {
                                f5 = f18 / f2 / 2.0f;
                                this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            this.glVertex3f(gL, f18 * f19, f18 * f20, 0.0f);
                        }
                        this.glEnd(gL);
                    }
                }
                for (n7 = 0; n7 <= n2; n7 += n2) {
                    f18 = f2 - f7 * ((float)n7 / (float)n2);
                    if (this.textureFlag) {
                        f5 = f18 / f2 / 2.0f;
                    }
                    this.glBegin(gL, 3);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        this.glVertex3f(gL, f18 * fArray[n3], f18 * fArray2[n3], 0.0f);
                    }
                    this.glEnd(gL);
                    if (f == f2) break block3;
                }
                break;
            }
        }
    }

    public void drawSphere(GL gL, float f, int n, int n2) {
        boolean bl = this.normals != 100002;
        float f2 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f3 = (float)Math.PI / (float)n2;
        float f4 = (float)Math.PI * 2 / (float)n;
        if (this.drawStyle == 100012) {
            float f5;
            float f6;
            int n3;
            int n4;
            float f7;
            float f8;
            float f9;
            float f10;
            int n5;
            if (!this.textureFlag) {
                this.glBegin(gL, 6);
                this.glNormal3f(gL, 0.0f, 0.0f, 1.0f);
                this.glVertex3f(gL, 0.0f, 0.0f, f2 * f);
                for (n5 = 0; n5 <= n; ++n5) {
                    f10 = n5 == n ? 0.0f : (float)n5 * f4;
                    f9 = -this.sin(f10) * this.sin(f3);
                    f8 = this.cos(f10) * this.sin(f3);
                    f7 = f2 * this.cos(f3);
                    if (bl) {
                        this.glNormal3f(gL, f9 * f2, f8 * f2, f7 * f2);
                    }
                    this.glVertex3f(gL, f9 * f, f8 * f, f7 * f);
                }
                this.glEnd(gL);
            }
            float f11 = 1.0f / (float)n;
            float f12 = 1.0f / (float)n2;
            float f13 = 1.0f;
            if (this.textureFlag) {
                n4 = 0;
                n3 = n2;
            } else {
                n4 = 1;
                n3 = n2 - 1;
            }
            for (int i = n4; i < n3; ++i) {
                f6 = (float)i * f3;
                this.glBegin(gL, 8);
                f5 = 0.0f;
                for (n5 = 0; n5 <= n; ++n5) {
                    f10 = n5 == n ? 0.0f : (float)n5 * f4;
                    f9 = -this.sin(f10) * this.sin(f6);
                    f8 = this.cos(f10) * this.sin(f6);
                    f7 = f2 * this.cos(f6);
                    if (bl) {
                        this.glNormal3f(gL, f9 * f2, f8 * f2, f7 * f2);
                    }
                    this.TXTR_COORD(gL, f5, f13);
                    this.glVertex3f(gL, f9 * f, f8 * f, f7 * f);
                    f9 = -this.sin(f10) * this.sin(f6 + f3);
                    f8 = this.cos(f10) * this.sin(f6 + f3);
                    f7 = f2 * this.cos(f6 + f3);
                    if (bl) {
                        this.glNormal3f(gL, f9 * f2, f8 * f2, f7 * f2);
                    }
                    this.TXTR_COORD(gL, f5, f13 - f12);
                    f5 += f11;
                    this.glVertex3f(gL, f9 * f, f8 * f, f7 * f);
                }
                this.glEnd(gL);
                f13 -= f12;
            }
            if (!this.textureFlag) {
                this.glBegin(gL, 6);
                this.glNormal3f(gL, 0.0f, 0.0f, -1.0f);
                this.glVertex3f(gL, 0.0f, 0.0f, -f * f2);
                f6 = (float)Math.PI - f3;
                f5 = 1.0f;
                for (n5 = n; n5 >= 0; --n5) {
                    f10 = n5 == n ? 0.0f : (float)n5 * f4;
                    f9 = -this.sin(f10) * this.sin(f6);
                    f8 = this.cos(f10) * this.sin(f6);
                    f7 = f2 * this.cos(f6);
                    if (bl) {
                        this.glNormal3f(gL, f9 * f2, f8 * f2, f7 * f2);
                    }
                    f5 -= f11;
                    this.glVertex3f(gL, f9 * f, f8 * f, f7 * f);
                }
                this.glEnd(gL);
            }
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f14;
            float f15;
            float f16;
            float f17;
            int n6;
            float f18;
            int n7;
            for (n7 = 1; n7 < n2; ++n7) {
                f18 = (float)n7 * f3;
                this.glBegin(gL, 2);
                for (n6 = 0; n6 < n; ++n6) {
                    f17 = (float)n6 * f4;
                    f16 = this.cos(f17) * this.sin(f18);
                    f15 = this.sin(f17) * this.sin(f18);
                    f14 = this.cos(f18);
                    if (bl) {
                        this.glNormal3f(gL, f16 * f2, f15 * f2, f14 * f2);
                    }
                    this.glVertex3f(gL, f16 * f, f15 * f, f14 * f);
                }
                this.glEnd(gL);
            }
            for (n6 = 0; n6 < n; ++n6) {
                f17 = (float)n6 * f4;
                this.glBegin(gL, 3);
                for (n7 = 0; n7 <= n2; ++n7) {
                    f18 = (float)n7 * f3;
                    f16 = this.cos(f17) * this.sin(f18);
                    f15 = this.sin(f17) * this.sin(f18);
                    f14 = this.cos(f18);
                    if (bl) {
                        this.glNormal3f(gL, f16 * f2, f15 * f2, f14 * f2);
                    }
                    this.glVertex3f(gL, f16 * f, f15 * f, f14 * f);
                }
                this.glEnd(gL);
            }
        } else if (this.drawStyle == 100010) {
            this.glBegin(gL, 0);
            if (bl) {
                this.glNormal3f(gL, 0.0f, 0.0f, f2);
            }
            this.glVertex3f(gL, 0.0f, 0.0f, f);
            if (bl) {
                this.glNormal3f(gL, 0.0f, 0.0f, -f2);
            }
            this.glVertex3f(gL, 0.0f, 0.0f, -f);
            for (int i = 1; i < n2 - 1; ++i) {
                float f19 = (float)i * f3;
                for (int j = 0; j < n; ++j) {
                    float f20 = (float)j * f4;
                    float f21 = this.cos(f20) * this.sin(f19);
                    float f22 = this.sin(f20) * this.sin(f19);
                    float f23 = this.cos(f19);
                    if (bl) {
                        this.glNormal3f(gL, f21 * f2, f22 * f2, f23 * f2);
                    }
                    this.glVertex3f(gL, f21 * f, f22 * f, f23 * f);
                }
            }
            this.glEnd(gL);
        }
    }

    private final void glBegin(GL gL, int n) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glBegin(n);
        } else {
            gL.getGL2().glBegin(n);
        }
    }

    private final void glEnd(GL gL) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glEnd(gL, this.immModeSinkImmediate);
        } else {
            gL.getGL2().glEnd();
        }
    }

    private final void glVertex2f(GL gL, float f, float f2) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glVertex2f(f, f2);
        } else {
            gL.getGL2().glVertex2f(f, f2);
        }
    }

    private final void glVertex3f(GL gL, float f, float f2, float f3) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glVertex3f(f, f2, f3);
        } else {
            gL.getGL2().glVertex3f(f, f2, f3);
        }
    }

    private final void glNormal3f_s(GL gL, float f, float f2, float f3) {
        short s = (short)(f * 65535.0f);
        short s2 = (short)(f2 * 65535.0f);
        short s3 = (short)(f3 * 65535.0f);
        if (this.immModeSinkEnabled) {
            this.immModeSink.glNormal3s(s, s2, s3);
        } else {
            gL.getGL2().glNormal3s(s, s2, s3);
        }
    }

    private final void glNormal3f_b(GL gL, float f, float f2, float f3) {
        byte by = (byte)(f * 255.0f);
        byte by2 = (byte)(f2 * 255.0f);
        byte by3 = (byte)(f3 * 255.0f);
        if (this.immModeSinkEnabled) {
            this.immModeSink.glNormal3b(by, by2, by3);
        } else {
            gL.getGL2().glNormal3b(by, by2, by3);
        }
    }

    private final void glNormal3f(GL gL, float f, float f2, float f3) {
        switch (this.normalType) {
            case 5126: {
                if (this.immModeSinkEnabled) {
                    this.immModeSink.glNormal3f(f, f2, f3);
                    break;
                }
                gL.getGL2().glNormal3f(f, f2, f3);
                break;
            }
            case 5122: {
                this.glNormal3f_s(gL, f, f2, f3);
                break;
            }
            case 5120: {
                this.glNormal3f_b(gL, f, f2, f3);
            }
        }
    }

    private final void glTexCoord2f(GL gL, float f, float f2) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glTexCoord2f(f, f2);
        } else {
            gL.getGL2().glTexCoord2f(f, f2);
        }
    }

    private void normal3f(GL gL, float f, float f2, float f3) {
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        if (f4 > 1.0E-5f) {
            f /= f4;
            f2 /= f4;
            f3 /= f4;
        }
        this.glNormal3f(gL, f, f2, f3);
    }

    private final void TXTR_COORD(GL gL, float f, float f2) {
        if (this.textureFlag) {
            this.glTexCoord2f(gL, f, f2);
        }
    }

    private float sin(float f) {
        return (float)Math.sin(f);
    }

    private float cos(float f) {
        return (float)Math.cos(f);
    }
}

