/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.InternalBufferUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.fixedfunc.GLMatrixFunc;

public class ProjectFloat {
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] ZERO_MATRIX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] matrix = new float[16];
    private final float[][] tempInvertMatrix = new float[4][4];
    private final float[] in = new float[4];
    private final float[] out = new float[4];
    private final float[] forward = new float[3];
    private final float[] side = new float[3];
    private final float[] up = new float[3];
    private FloatBuffer locbuf = InternalBufferUtil.newFloatBuffer(49);
    private final FloatBuffer matrixBuf;
    private final FloatBuffer tempInvertMatrixBuf;
    private final FloatBuffer inBuf;
    private final FloatBuffer outBuf;
    private final FloatBuffer forwardBuf;
    private final FloatBuffer sideBuf;
    private final FloatBuffer upBuf;

    public ProjectFloat() {
        int n = 0;
        int n2 = 16;
        this.matrixBuf = ProjectFloat.slice(this.locbuf, n, n2);
        this.tempInvertMatrixBuf = ProjectFloat.slice(this.locbuf, n += n2, n2);
        n += n2;
        n2 = 4;
        this.inBuf = ProjectFloat.slice(this.locbuf, n, n2);
        this.outBuf = ProjectFloat.slice(this.locbuf, n += n2, n2);
        n += n2;
        n2 = 3;
        this.forwardBuf = ProjectFloat.slice(this.locbuf, n, n2);
        this.sideBuf = ProjectFloat.slice(this.locbuf, n += n2, n2);
        this.upBuf = ProjectFloat.slice(this.locbuf, n += n2, n2);
    }

    public void destroy() {
        if (this.locbuf != null) {
            this.locbuf.clear();
            this.locbuf = null;
        }
    }

    private static FloatBuffer slice(FloatBuffer floatBuffer, int n, int n2) {
        floatBuffer.position(n);
        floatBuffer.limit(n + n2);
        return floatBuffer.slice();
    }

    public static void gluMakeIdentityf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        floatBuffer.put(IDENTITY_MATRIX);
        floatBuffer.position(n);
    }

    public static void gluMakeZero(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        floatBuffer.put(ZERO_MATRIX);
        floatBuffer.position(n);
    }

    public static void gluMakeIdentityf(float[] fArray) {
        for (int i = 0; i < 16; ++i) {
            fArray[i] = IDENTITY_MATRIX[i];
        }
    }

    private void __gluMultMatrixVecf(float[] fArray, int n, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < 4; ++i) {
            fArray3[i] = fArray2[0] * fArray[0 + i + n] + fArray2[1] * fArray[4 + i + n] + fArray2[2] * fArray[8 + i + n] + fArray2[3] * fArray[12 + i + n];
        }
    }

    private void __gluMultMatrixVecf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer2.position();
        int n2 = floatBuffer3.position();
        int n3 = floatBuffer.position();
        for (int i = 0; i < 4; ++i) {
            floatBuffer3.put(i + n2, floatBuffer2.get(0 + n) * floatBuffer.get(0 + i + n3) + floatBuffer2.get(1 + n) * floatBuffer.get(4 + i + n3) + floatBuffer2.get(2 + n) * floatBuffer.get(8 + i + n3) + floatBuffer2.get(3 + n) * floatBuffer.get(12 + i + n3));
        }
    }

    public boolean gluInvertMatrixf(float[] fArray, float[] fArray2) {
        int n;
        int n2;
        float[][] fArray3 = this.tempInvertMatrix;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                fArray3[n2][n] = fArray[n2 * 4 + n];
            }
        }
        ProjectFloat.gluMakeIdentityf(fArray2);
        for (n2 = 0; n2 < 4; ++n2) {
            float f;
            int n3;
            int n4 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(fArray3[n][n2]) > Math.abs(fArray3[n2][n2]))) continue;
                n4 = n;
            }
            if (n4 != n2) {
                for (n3 = 0; n3 < 4; ++n3) {
                    f = fArray3[n2][n3];
                    fArray3[n2][n3] = fArray3[n4][n3];
                    fArray3[n4][n3] = f;
                    f = fArray2[n2 * 4 + n3];
                    fArray2[n2 * 4 + n3] = fArray2[n4 * 4 + n3];
                    fArray2[n4 * 4 + n3] = f;
                }
            }
            if (fArray3[n2][n2] == 0.0f) {
                return false;
            }
            f = fArray3[n2][n2];
            for (n3 = 0; n3 < 4; ++n3) {
                float[] fArray4 = fArray3[n2];
                int n5 = n3;
                fArray4[n5] = fArray4[n5] / f;
                int n6 = n2 * 4 + n3;
                fArray2[n6] = fArray2[n6] / f;
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                f = fArray3[n][n2];
                for (n3 = 0; n3 < 4; ++n3) {
                    float[] fArray5 = fArray3[n];
                    int n7 = n3;
                    fArray5[n7] = fArray5[n7] - fArray3[n2][n3] * f;
                    int n8 = n * 4 + n3;
                    fArray2[n8] = fArray2[n8] - fArray2[n2 * 4 + n3] * f;
                }
            }
        }
        return true;
    }

    public boolean gluInvertMatrixf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n;
        int n2;
        int n3 = floatBuffer.position();
        int n4 = floatBuffer2.position();
        FloatBuffer floatBuffer3 = this.tempInvertMatrixBuf;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                floatBuffer3.put(n2 * 4 + n, floatBuffer.get(n2 * 4 + n + n3));
            }
        }
        ProjectFloat.gluMakeIdentityf(floatBuffer2);
        for (n2 = 0; n2 < 4; ++n2) {
            float f;
            int n5;
            int n6 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(floatBuffer3.get(n * 4 + n2)) > Math.abs(floatBuffer3.get(n2 * 4 + n2)))) continue;
                n6 = n;
            }
            if (n6 != n2) {
                for (n5 = 0; n5 < 4; ++n5) {
                    f = floatBuffer3.get(n2 * 4 + n5);
                    floatBuffer3.put(n2 * 4 + n5, floatBuffer3.get(n6 * 4 + n5));
                    floatBuffer3.put(n6 * 4 + n5, f);
                    f = floatBuffer2.get(n2 * 4 + n5 + n4);
                    floatBuffer2.put(n2 * 4 + n5 + n4, floatBuffer2.get(n6 * 4 + n5 + n4));
                    floatBuffer2.put(n6 * 4 + n5 + n4, f);
                }
            }
            if (floatBuffer3.get(n2 * 4 + n2) == 0.0f) {
                return false;
            }
            f = floatBuffer3.get(n2 * 4 + n2);
            for (n5 = 0; n5 < 4; ++n5) {
                floatBuffer3.put(n2 * 4 + n5, floatBuffer3.get(n2 * 4 + n5) / f);
                floatBuffer2.put(n2 * 4 + n5 + n4, floatBuffer2.get(n2 * 4 + n5 + n4) / f);
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                f = floatBuffer3.get(n * 4 + n2);
                for (n5 = 0; n5 < 4; ++n5) {
                    floatBuffer3.put(n * 4 + n5, floatBuffer3.get(n * 4 + n5) - floatBuffer3.get(n2 * 4 + n5) * f);
                    floatBuffer2.put(n * 4 + n5 + n4, floatBuffer2.get(n * 4 + n5 + n4) - floatBuffer2.get(n2 * 4 + n5 + n4) * f);
                }
            }
        }
        return true;
    }

    private void gluMultMatricesf(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                fArray3[i * 4 + j] = fArray[i * 4 + 0 + n] * fArray2[0 + j + n2] + fArray[i * 4 + 1 + n] * fArray2[4 + j + n2] + fArray[i * 4 + 2 + n] * fArray2[8 + j + n2] + fArray[i * 4 + 3 + n] * fArray2[12 + j + n2];
            }
        }
    }

    public static void gluMultMatricesf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        int n3 = floatBuffer3.position();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                floatBuffer3.put(i * 4 + j + n3, floatBuffer.get(i * 4 + 0 + n) * floatBuffer2.get(0 + j + n2) + floatBuffer.get(i * 4 + 1 + n) * floatBuffer2.get(4 + j + n2) + floatBuffer.get(i * 4 + 2 + n) * floatBuffer2.get(8 + j + n2) + floatBuffer.get(i * 4 + 3 + n) * floatBuffer2.get(12 + j + n2));
            }
        }
    }

    public static void normalize(float[] fArray) {
        float f = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if ((double)f == 0.0 || (double)f == 1.0) {
            return;
        }
        f = 1.0f / f;
        fArray[0] = fArray[0] * f;
        fArray[1] = fArray[1] * f;
        fArray[2] = fArray[2] * f;
    }

    public static void normalize(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        float f = (float)Math.sqrt(floatBuffer.get(0 + n) * floatBuffer.get(0 + n) + floatBuffer.get(1 + n) * floatBuffer.get(1 + n) + floatBuffer.get(2 + n) * floatBuffer.get(2 + n));
        if ((double)f == 0.0 || (double)f == 1.0) {
            return;
        }
        f = 1.0f / f;
        floatBuffer.put(0 + n, floatBuffer.get(0 + n) * f);
        floatBuffer.put(1 + n, floatBuffer.get(1 + n) * f);
        floatBuffer.put(2 + n, floatBuffer.get(2 + n) * f);
    }

    private static void cross(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }

    private static void cross(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        int n3 = floatBuffer3.position();
        floatBuffer3.put(0 + n3, floatBuffer.get(1 + n) * floatBuffer2.get(2 + n2) - floatBuffer.get(2 + n) * floatBuffer2.get(1 + n2));
        floatBuffer3.put(1 + n3, floatBuffer.get(2 + n) * floatBuffer2.get(0 + n2) - floatBuffer.get(0 + n) * floatBuffer2.get(2 + n2));
        floatBuffer3.put(2 + n3, floatBuffer.get(0 + n) * floatBuffer2.get(1 + n2) - floatBuffer.get(1 + n) * floatBuffer2.get(0 + n2));
    }

    public void gluOrtho2D(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        gLMatrixFunc.glOrthof(f, f2, f3, f4, -1.0f, 1.0f);
    }

    public void gluPerspective(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        float f5 = f / 2.0f * (float)Math.PI / 180.0f;
        float f6 = f4 - f3;
        float f7 = (float)Math.sin(f5);
        if (f6 == 0.0f || f7 == 0.0f || f2 == 0.0f) {
            return;
        }
        float f8 = (float)Math.cos(f5) / f7;
        ProjectFloat.gluMakeIdentityf(this.matrixBuf);
        this.matrixBuf.put(0, f8 / f2);
        this.matrixBuf.put(5, f8);
        this.matrixBuf.put(10, -(f4 + f3) / f6);
        this.matrixBuf.put(11, -1.0f);
        this.matrixBuf.put(14, -2.0f * f3 * f4 / f6);
        this.matrixBuf.put(15, 0.0f);
        gLMatrixFunc.glMultMatrixf(this.matrixBuf);
    }

    public void gluLookAt(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        FloatBuffer floatBuffer = this.forwardBuf;
        FloatBuffer floatBuffer2 = this.sideBuf;
        FloatBuffer floatBuffer3 = this.upBuf;
        floatBuffer.put(0, f4 - f);
        floatBuffer.put(1, f5 - f2);
        floatBuffer.put(2, f6 - f3);
        floatBuffer3.put(0, f7);
        floatBuffer3.put(1, f8);
        floatBuffer3.put(2, f9);
        ProjectFloat.normalize(floatBuffer);
        ProjectFloat.cross(floatBuffer, floatBuffer3, floatBuffer2);
        ProjectFloat.normalize(floatBuffer2);
        ProjectFloat.cross(floatBuffer2, floatBuffer, floatBuffer3);
        ProjectFloat.gluMakeIdentityf(this.matrixBuf);
        this.matrixBuf.put(0, floatBuffer2.get(0));
        this.matrixBuf.put(4, floatBuffer2.get(1));
        this.matrixBuf.put(8, floatBuffer2.get(2));
        this.matrixBuf.put(1, floatBuffer3.get(0));
        this.matrixBuf.put(5, floatBuffer3.get(1));
        this.matrixBuf.put(9, floatBuffer3.get(2));
        this.matrixBuf.put(2, -floatBuffer.get(0));
        this.matrixBuf.put(6, -floatBuffer.get(1));
        this.matrixBuf.put(10, -floatBuffer.get(2));
        gLMatrixFunc.glMultMatrixf(this.matrixBuf);
        gLMatrixFunc.glTranslatef(-f, -f2, -f3);
    }

    public boolean gluProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        this.__gluMultMatrixVecf(fArray, n, fArray4, fArray5);
        this.__gluMultMatrixVecf(fArray2, n2, fArray5, fArray4);
        if (fArray4[3] == 0.0f) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3] * 0.5f;
        fArray4[0] = fArray4[0] * fArray4[3] + 0.5f;
        fArray4[1] = fArray4[1] * fArray4[3] + 0.5f;
        fArray4[2] = fArray4[2] * fArray4[3] + 0.5f;
        fArray3[0 + n4] = fArray4[0] * (float)nArray[2 + n3] + (float)nArray[0 + n3];
        fArray3[1 + n4] = fArray4[1] * (float)nArray[3 + n3] + (float)nArray[1 + n3];
        fArray3[2 + n4] = fArray4[2];
        return true;
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        FloatBuffer floatBuffer4 = this.inBuf;
        FloatBuffer floatBuffer5 = this.outBuf;
        floatBuffer4.put(0, f);
        floatBuffer4.put(1, f2);
        floatBuffer4.put(2, f3);
        floatBuffer4.put(3, 1.0f);
        this.__gluMultMatrixVecf(floatBuffer, floatBuffer4, floatBuffer5);
        this.__gluMultMatrixVecf(floatBuffer2, floatBuffer5, floatBuffer4);
        if (floatBuffer4.get(3) == 0.0f) {
            return false;
        }
        floatBuffer4.put(3, 1.0f / floatBuffer4.get(3) * 0.5f);
        floatBuffer4.put(0, floatBuffer4.get(0) * floatBuffer4.get(3) + 0.5f);
        floatBuffer4.put(1, floatBuffer4.get(1) * floatBuffer4.get(3) + 0.5f);
        floatBuffer4.put(2, floatBuffer4.get(2) * floatBuffer4.get(3) + 0.5f);
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, floatBuffer4.get(0) * (float)intBuffer.get(2 + n) + (float)intBuffer.get(0 + n));
        floatBuffer3.put(1 + n2, floatBuffer4.get(1) * (float)intBuffer.get(3 + n) + (float)intBuffer.get(1 + n));
        floatBuffer3.put(2 + n2, floatBuffer4.get(2));
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        this.gluMultMatricesf(fArray, n, fArray2, n2, this.matrix);
        if (!this.gluInvertMatrixf(this.matrix, this.matrix)) {
            return false;
        }
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        this.__gluMultMatrixVecf(this.matrix, 0, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray3[0 + n4] = fArray5[0] * fArray5[3];
        fArray3[1 + n4] = fArray5[1] * fArray5[3];
        fArray3[2 + n4] = fArray5[2] * fArray5[3];
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        FloatBuffer floatBuffer4 = this.inBuf;
        FloatBuffer floatBuffer5 = this.outBuf;
        ProjectFloat.gluMultMatricesf(floatBuffer, floatBuffer2, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        floatBuffer4.put(0, f);
        floatBuffer4.put(1, f2);
        floatBuffer4.put(2, f3);
        floatBuffer4.put(3, 1.0f);
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        floatBuffer4.put(0, (floatBuffer4.get(0) - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n));
        floatBuffer4.put(1, (floatBuffer4.get(1) - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n));
        floatBuffer4.put(0, floatBuffer4.get(0) * 2.0f - 1.0f);
        floatBuffer4.put(1, floatBuffer4.get(1) * 2.0f - 1.0f);
        floatBuffer4.put(2, floatBuffer4.get(2) * 2.0f - 1.0f);
        this.__gluMultMatrixVecf(this.matrixBuf, floatBuffer4, floatBuffer5);
        if (floatBuffer5.get(3) == 0.0f) {
            return false;
        }
        floatBuffer5.put(3, 1.0f / floatBuffer5.get(3));
        floatBuffer3.put(0 + n2, floatBuffer5.get(0) * floatBuffer5.get(3));
        floatBuffer3.put(1 + n2, floatBuffer5.get(1) * floatBuffer5.get(3));
        floatBuffer3.put(2 + n2, floatBuffer5.get(2) * floatBuffer5.get(3));
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float f5, float f6, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        this.gluMultMatricesf(fArray, n, fArray2, n2, this.matrix);
        if (!this.gluInvertMatrixf(this.matrix, this.matrix)) {
            return false;
        }
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = f4;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray4[2] = (fArray4[2] - f5) / (f6 - f5);
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        this.__gluMultMatrixVecf(this.matrix, 0, fArray4, fArray5);
        if (fArray5[3] == 0.0f) {
            return false;
        }
        fArray3[0 + n4] = fArray5[0];
        fArray3[1 + n4] = fArray5[1];
        fArray3[2 + n4] = fArray5[2];
        fArray3[3 + n4] = fArray5[3];
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, float f5, float f6, FloatBuffer floatBuffer3) {
        FloatBuffer floatBuffer4 = this.inBuf;
        FloatBuffer floatBuffer5 = this.outBuf;
        ProjectFloat.gluMultMatricesf(floatBuffer, floatBuffer2, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        floatBuffer4.put(0, f);
        floatBuffer4.put(1, f2);
        floatBuffer4.put(2, f3);
        floatBuffer4.put(3, f4);
        int n = intBuffer.position();
        floatBuffer4.put(0, (floatBuffer4.get(0) - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n));
        floatBuffer4.put(1, (floatBuffer4.get(1) - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n));
        floatBuffer4.put(2, (floatBuffer4.get(2) - f5) / (f6 - f5));
        floatBuffer4.put(0, floatBuffer4.get(0) * 2.0f - 1.0f);
        floatBuffer4.put(1, floatBuffer4.get(1) * 2.0f - 1.0f);
        floatBuffer4.put(2, floatBuffer4.get(2) * 2.0f - 1.0f);
        this.__gluMultMatrixVecf(this.matrixBuf, floatBuffer4, floatBuffer5);
        if (floatBuffer5.get(3) == 0.0f) {
            return false;
        }
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, floatBuffer5.get(0));
        floatBuffer3.put(1 + n2, floatBuffer5.get(1));
        floatBuffer3.put(2 + n2, floatBuffer5.get(2));
        floatBuffer3.put(3 + n2, floatBuffer5.get(3));
        return true;
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, IntBuffer intBuffer) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        int n = intBuffer.position();
        gLMatrixFunc.glTranslatef(((float)intBuffer.get(2 + n) - 2.0f * (f - (float)intBuffer.get(0 + n))) / f3, ((float)intBuffer.get(3 + n) - 2.0f * (f2 - (float)intBuffer.get(1 + n))) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)intBuffer.get(2) / f3, (float)intBuffer.get(3) / f4, 1.0f);
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, int[] nArray, int n) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        gLMatrixFunc.glTranslatef(((float)nArray[2 + n] - 2.0f * (f - (float)nArray[0 + n])) / f3, ((float)nArray[3 + n] - 2.0f * (f2 - (float)nArray[1 + n])) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)nArray[2 + n] / f3, (float)nArray[3 + n] / f4, 1.0f);
    }
}

