/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.media.opengl.GL;

public final class ExtensionAvailabilityCache {
    private static final boolean DEBUG = Debug.debug("ExtensionAvailabilityCache");
    private static final boolean DEBUG_AVAILABILITY = Debug.isPropertyDefined("ExtensionAvailabilityCache", true);
    private boolean initialized = false;
    private int majorVersion = 1;
    private int minorVersion = 0;
    private String glExtensions = null;
    private String glXExtensions = null;
    private HashSet availableExtensionCache = new HashSet(50);
    private GLContextImpl context;

    ExtensionAvailabilityCache(GLContextImpl gLContextImpl) {
        this.context = gLContextImpl;
    }

    public void flush() {
        if (DEBUG) {
            System.out.println("ExtensionAvailabilityCache: Flush availability OpenGL " + this.majorVersion + "." + this.minorVersion);
        }
        this.availableExtensionCache.clear();
        this.initialized = false;
        this.majorVersion = 1;
        this.minorVersion = 0;
    }

    public void reset() {
        this.flush();
        this.initAvailableExtensions();
    }

    public boolean isInitialized() {
        return this.initialized && !this.availableExtensionCache.isEmpty();
    }

    public boolean isExtensionAvailable(String string) {
        this.initAvailableExtensions();
        return this.availableExtensionCache.contains(ExtensionAvailabilityCache.mapGLExtensionName(string));
    }

    public String getPlatformExtensionsString() {
        this.initAvailableExtensions();
        return this.glXExtensions;
    }

    public String getGLExtensions() {
        this.initAvailableExtensions();
        if (DEBUG) {
            System.err.println("ExtensionAvailabilityCache: getGLExtensions() called");
        }
        return this.glExtensions;
    }

    public int getMajorVersion() {
        this.initAvailableExtensions();
        return this.majorVersion;
    }

    public int getMinorVersion() {
        this.initAvailableExtensions();
        return this.minorVersion;
    }

    private void initAvailableExtensions() {
        if (this.availableExtensionCache.isEmpty() || !this.initialized) {
            int n;
            Object object;
            Object object2;
            Version version;
            GL gL = this.context.getGL();
            if (DEBUG) {
                System.err.println("ExtensionAvailabilityCache: Pre-caching init " + gL + ", GL_VERSION " + gL.glGetString(7938));
            }
            if ((version = new Version(gL.glGetString(7938))).isValid()) {
                this.majorVersion = version.getMajor();
                this.minorVersion = version.getMinor();
                if (!gL.isGL3() && (this.majorVersion > 3 || this.majorVersion == 3 && this.minorVersion >= 1)) {
                    this.majorVersion = 3;
                    this.minorVersion = 0;
                }
            }
            boolean bl = false;
            if (this.majorVersion > 3 || this.majorVersion == 3 && this.minorVersion >= 0 || gL.isGL3()) {
                if (!gL.isGL2GL3()) {
                    if (DEBUG) {
                        System.err.println("ExtensionAvailabilityCache: GL >= 3.1 usage, but no GL2GL3 interface: " + gL.getClass().getName());
                    }
                } else if (!gL.isFunctionAvailable("glGetStringi")) {
                    if (DEBUG) {
                        System.err.println("ExtensionAvailabilityCache: GL >= 3.1 usage, but no glGetStringi");
                    }
                } else {
                    bl = true;
                }
            }
            if (DEBUG) {
                System.err.println("ExtensionAvailabilityCache: Pre-caching extension availability OpenGL " + this.majorVersion + "." + this.minorVersion + ", use " + (bl ? "glGetStringi" : "glGetString"));
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                object2 = gL.getGL2GL3();
                object = new int[]{0};
                object2.glGetIntegerv(33309, (int[])object, 0);
                for (n = 0; n < object[0]; ++n) {
                    stringBuffer.append(object2.glGetStringi(7939, n));
                    if (n >= object[0]) continue;
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(gL.glGetString(7939));
            }
            this.glExtensions = stringBuffer.toString();
            this.glXExtensions = this.context.getPlatformExtensionsString();
            stringBuffer.append(" ");
            stringBuffer.append(this.glXExtensions);
            object2 = stringBuffer.toString();
            if (DEBUG_AVAILABILITY) {
                System.err.println("ExtensionAvailabilityCache: Available extensions: " + (String)object2);
                System.err.println("ExtensionAvailabilityCache: GL vendor: " + gL.glGetString(7936));
            }
            object = new StringTokenizer((String)object2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                string = string.intern();
                this.availableExtensionCache.add(string);
                if (!DEBUG_AVAILABILITY) continue;
                System.err.println("ExtensionAvailabilityCache:   Available: " + string);
            }
            int n2 = this.minorVersion;
            block6: for (n = this.majorVersion; n > 0; --n) {
                while (n2 >= 0) {
                    this.availableExtensionCache.add("GL_VERSION_" + n + "_" + n2);
                    if (DEBUG) {
                        System.err.println("ExtensionAvailabilityCache: Added GL_VERSION_" + n + "_" + n2 + " to known extensions");
                    }
                    --n2;
                }
                switch (n) {
                    case 3: {
                        if (gL.isGL3()) {
                            n = 0;
                        }
                        n2 = 1;
                        continue block6;
                    }
                    case 2: {
                        n2 = 5;
                        continue block6;
                    }
                }
            }
            this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
            this.initialized = true;
        }
    }

    private static String mapGLExtensionName(String string) {
        if (string != null && (string.equals("WGL_NV_vertex_array_range") || string.equals("GLX_NV_vertex_array_range"))) {
            return "GL_NV_vertex_array_range";
        }
        return string;
    }

    private static class Version
    implements Comparable {
        private boolean valid;
        private int major;
        private int minor;
        private int sub;

        public Version(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.sub = n3;
        }

        public Version(String string) {
            try {
                if (string.startsWith("GL_VERSION_")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.major = 0;
                        return;
                    }
                    this.major = Integer.valueOf(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.minor = 0;
                        return;
                    }
                    this.minor = Integer.valueOf(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.sub = 0;
                        return;
                    }
                    this.sub = Integer.valueOf(stringTokenizer.nextToken());
                } else {
                    int n = 10;
                    if (string.length() > 2 && Character.isDigit(string.charAt(0)) && string.charAt(1) == '.' && Character.isDigit(string.charAt(2))) {
                        this.major = Character.digit(string.charAt(0), n);
                        this.minor = Character.digit(string.charAt(2), n);
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                        if (stringTokenizer.hasMoreTokens()) {
                            stringTokenizer.nextToken();
                            if (stringTokenizer.hasMoreTokens()) {
                                int n2;
                                String string2 = stringTokenizer.nextToken();
                                for (n2 = 0; n2 < string2.length() && !Character.isDigit(string2.charAt(n2)); ++n2) {
                                }
                                if (n2 < string2.length() - 2 && Character.isDigit(string2.charAt(n2)) && string2.charAt(n2 + 1) == '.' && Character.isDigit(string2.charAt(n2 + 2))) {
                                    int n3 = Character.digit(string2.charAt(n2), n);
                                    int n4 = Character.digit(string2.charAt(n2 + 2), n);
                                    if (n3 == this.major && n4 > this.minor || n3 == this.major + 1) {
                                        this.major = n3;
                                        this.minor = n4;
                                    }
                                }
                            }
                        }
                    }
                }
                this.valid = true;
            }
            catch (Exception exception) {
                System.err.println("ExtensionAvailabilityCache: FunctionAvailabilityCache.Version.<init>: " + exception);
                this.major = 1;
                this.minor = 0;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public int compareTo(Object object) {
            Version version = (Version)object;
            if (this.major > version.major) {
                return 1;
            }
            if (this.major < version.major) {
                return -1;
            }
            if (this.minor > version.minor) {
                return 1;
            }
            if (this.minor < version.minor) {
                return -1;
            }
            if (this.sub > version.sub) {
                return 1;
            }
            if (this.sub < version.sub) {
                return -1;
            }
            return 0;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

