/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.services;

import java.lang.reflect.Field;

import ch.kuramo.javie.core.JavieException;

public class ShaderBuildException extends JavieException {

	private static final long serialVersionUID = 1L;

	public ShaderBuildException(Field field) {
		super(format(field, ""));
	}

	public ShaderBuildException(Field field, String message, Throwable cause) {
		super(format(field, message), cause);
	}

	public ShaderBuildException(Field field, String message) {
		super(format(field, message));
	}

	public ShaderBuildException(Field field, Throwable cause) {
		super(format(field, ""), cause);
	}

	private static String format(Field field, String message) {
		return String.format("[%s.%s] %s", field.getDeclaringClass().getName(), field.getName(), message);
	}

}
