/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.widgets;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.FrameDuration;

public class FrameRateComboUtil {

	private static final Time[] frameDurations = FrameDuration.values();

	private static final String[] comboItems = new String[frameDurations.length];

	static {
		for (int i = 0; i < frameDurations.length; ++i) {
			comboItems[i] = formatComboItem(frameDurations[i]);
		}
	}


	public static String[] getComboItems() {
		return comboItems.clone();
	}

	public static Time toFrameDuration(String comboItem) {
		for (int i = 0; i < comboItems.length; ++i) {
			if (comboItem.equals(comboItems[i])) {
				return frameDurations[i];
			}
		}
		int timeValue = (int) (10000000 / Double.parseDouble(comboItem));
		return new Time(timeValue, 10000000);
	}

	public static String toComboItem(Time frameDuration) {
		for (int i = 0; i < frameDurations.length; ++i) {
			if (frameDuration.equals(frameDurations[i])) {
				return comboItems[i];
			}
		}
		return formatComboItem(frameDuration);
	}

	private static String formatComboItem(Time frameDuration) {
		String item = String.format("%.3f", (double) frameDuration.timeScale / frameDuration.timeValue);
		for (int i = item.length() - 1; ; --i) {
			switch (item.charAt(i)) {
				case '0': continue;
				case '.': return item.substring(0, i);
				default : return item.substring(0, i+1);
			}
		}
	}


	private FrameRateComboUtil() { }

}
