/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.core.Util;

public class SwitchGroup {

	private static final boolean WIN32 = SWT.getPlatform().equals("win32");


	private final List<Switch> switches = Util.newList();

	private final List<Rectangle> switchArea = Util.newList();


	public void add(Switch s) {
		switches.add(s);
	}

	public void addPlaceholder() {
		switches.add(null);
	}

	public void redraw(Control control) {
		for (Rectangle r : switchArea) {
			control.redraw(r.x, r.y, r.width, r.height, false);
		}
	}

	public void paint(Event event) {
		switchArea.clear();

		for (int i = 0, n = switches.size(); i < n; ++i) {
			paintSwitch(event, i, switches.get(i));
		}
	}

	public void mouseDown(MouseEvent event) {
		if (event.button != 1) {
			return;
		}

		for (int i = 0, n = switchArea.size(); i < n; ++i) {
			Rectangle r = switchArea.get(i);
			if (r != null && r.contains(event.x, event.y)) {
				switches.get(i).mouseDown(event);
				break;
			}
		}
	}

	private void paintSwitch(Event event, int index, Switch s) {
		if (s == null) {
			switchArea.add(null);
			return;
		}


		int x = event.x + 5 + 16*index;
		int y = event.y + (WIN32 ? 2 : 3);
		GC gc = event.gc;

		switchArea.add(new Rectangle(x, y, 15, 15));


		if (s.hasBorder()) {
			boolean hilighted = (event.detail & SWT.SELECTED) != 0;
			boolean focused = ((Control) event.widget).isFocusControl();
			boolean layerSwitch = (s instanceof LayerSwitch);

			gc.setLineDash(null);

			gc.setForeground(ColorUtil.switchBorderTopLeft(hilighted, focused, layerSwitch));
			gc.drawLine(x, y, x+13, y);
			gc.drawLine(x, y, x   , y+13);

			gc.setForeground(ColorUtil.switchBorderBottomRight(hilighted, focused, layerSwitch));
			gc.drawLine(x+14, y+1 , x+14, y+14);
			gc.drawLine(x+1 , y+14, x+14, y+14);
		}

		Image image = s.getImage();
		if (image != null) {
			gc.drawImage(image, x+1, y+1);
		}
	}

}
