/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

import ch.kuramo.javie.app.player.MediaPlayer;
import ch.kuramo.javie.app.player.PlayerInfoAction;
import ch.kuramo.javie.app.player.PlayerMuteAction;
import ch.kuramo.javie.app.player.PlayerPinAction;
import ch.kuramo.javie.app.player.PlayerResolutionAction;
import ch.kuramo.javie.app.player.PlayerZoomAction;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.MediaItem;

public class MediaPlayerView extends ViewPart implements IPartListener2 {

	public static final String ID = "ch.kuramo.javie.app.views.mediaPlayerView";


	private MediaItem _mediaItem;

	private MediaPlayer _mediaPlayer;

	private PlayerZoomAction _zoomAction;

	private PlayerResolutionAction _resolutionAction;

	private PlayerMuteAction _muteAction;

	private PlayerInfoAction _infoAction;

	private PlayerPinAction _pinAction;


	public void createPartControl(Composite parent) {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(getSite().getWorkbenchWindow());
		if (pm == null) {
			throw new IllegalStateException("No ProjectManager exists for this window.");
		}

		_mediaItem = pm.getShadow().getItem(getItemId());
		if (_mediaItem == null) {
			throw new IllegalStateException("no such MediaItem found: " + getItemId());
		}

		setPartName(_mediaItem.getName());

		_mediaPlayer = new MediaPlayer(parent, SWT.NULL);
		_mediaPlayer.setMediaItem(_mediaItem);

		configureActionBars();

		if (_mediaItem instanceof CompositionItem) {
			LayerCompositionView.connectToPlayer(this);
		}

		getSite().getPage().addPartListener(this);
	}

	private void configureActionBars() {
		IActionBars actionBars = getViewSite().getActionBars();
		IToolBarManager tbm = actionBars.getToolBarManager();

		_zoomAction = new PlayerZoomAction(_mediaPlayer);
		tbm.add(_zoomAction);

		_resolutionAction = new PlayerResolutionAction(_mediaPlayer);
		tbm.add(_resolutionAction);

		_muteAction = new PlayerMuteAction(_mediaPlayer);
		tbm.add(_muteAction);

		tbm.add(new Separator());

		_infoAction = new PlayerInfoAction(_mediaPlayer);
		tbm.add(_infoAction);

		_pinAction = new PlayerPinAction();
		tbm.add(_pinAction);

		actionBars.updateActionBars();
	}

	public void dispose() {
		getSite().getPage().removePartListener(this);
		super.dispose();
	}

	public void setFocus() {
		_mediaPlayer.setFocus();
	}

	String getItemId() {
		return getViewSite().getSecondaryId();
	}

	MediaPlayer getMediaPlayer() {
		return _mediaPlayer;
	}

	public boolean isPinned() {
		return _pinAction.isChecked();
	}

	public void partOpened(IWorkbenchPartReference partRef) {
		// nothing to do
	}

	public void partClosed(IWorkbenchPartReference partRef) {
		if (partRef.getPart(false) == this) {
			_mediaPlayer.close();
		}
	}

	public void partVisible(IWorkbenchPartReference partRef) {
		if (partRef.getPart(false) == this) {
			_mediaPlayer.setHidden(false);
		}
	}

	public void partHidden(IWorkbenchPartReference partRef) {
		if (partRef.getPart(false) == this) {
			_mediaPlayer.setHidden(true);
		}
	}

	public void partActivated(IWorkbenchPartReference partRef) {
		// nothing to do
	}

	public void partDeactivated(IWorkbenchPartReference partRef) {
		// nothing to do
	}

	public void partBroughtToTop(IWorkbenchPartReference partRef) {
		// nothing to do
	}

	public void partInputChanged(IWorkbenchPartReference partRef) {
		// nothing to do
	}

}
