/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaLayer;

public class DisableTimeRemapOperation extends ProjectOperationCollection {

	public DisableTimeRemapOperation(ProjectManager pm, MediaLayer layer) {
		super(pm, "タイムリマップの解除");
		LayerComposition comp = pm.checkLayer(layer);

		double rate = layer.getRate();
		Time duration = layer.getMediaInput().getDuration();
		Time startTime = layer.getStartTime();
		Time endTime = startTime.add(new Time((long)(duration.timeValue/Math.abs(rate)), duration.timeScale));

		Time inPoint = layer.getInPoint();
		Time outPoint = layer.getOutPoint();

		if (inPoint.before(startTime)) {
			Object[][] layersAndInPoints = new Object[][] { new Object[] { layer, inPoint } };
			add(new ModifyLayerInPointOperation(pm, comp, layersAndInPoints, startTime.subtract(inPoint), null));
		}

		if (outPoint.after(endTime)) {
			Object[][] layersAndOutPoints = new Object[][] { new Object[] { layer, outPoint } };
			add(new ModifyLayerOutPointOperation(pm, comp, layersAndOutPoints, endTime.subtract(outPoint), null));
		}

		add(new ClearLayerKeyframesOperation<Double>(pm, layer, "timeRemap"));
	}

}
