/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.util.Set;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ReverseLayerTimeOperation;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.Util;

public class ReverseLayerTimeAction extends Action {

	private final TreeViewer viewer;

	public ReverseLayerTimeAction(TreeViewer viewer) {
		super("レイヤーの時間反転");
		this.viewer = viewer;

		setEnabled(false);

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				boolean enabled = false;

				TreeSelection selection = (TreeSelection) event.getSelection();
				if (!selection.isEmpty()) {
					enabled = true;
					for (Object element : selection.toList()) {
						if (!(element instanceof LayerElement)) {
							enabled = false;
							break;
						}
					}
				}

				setEnabled(enabled);
			}
		});
	}

	public void run() {
		Set<Layer> layers = Util.newSet();

		TreeSelection selection = (TreeSelection) viewer.getSelection();
		for (Object element : selection.toList()) {
			if (!(element instanceof LayerElement)) {
				return;
			}
			layers.add(((LayerElement) element).layer);
		}

		if (layers.isEmpty()) {
			return;
		}

		ProjectManager pm = (ProjectManager) viewer.getData(LayerCompositionView.PROJECT_MANAGER);
		pm.postOperation(new ReverseLayerTimeOperation(pm, layers));
	}

}
