/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.views.ProjectView;
import ch.kuramo.javie.core.Item;

public class RenameItemAction extends Action implements ISelectionChangedListener {

	private final IWorkbenchWindow window;

	private Item item;


	public RenameItemAction(IWorkbenchWindow window, Viewer viewer) {
		super("名前の変更");
		this.window = window;

		//setId(CommandIds.RENAME_ITEM);
		//setActionDefinitionId(CommandIds.RENAME_ITEM);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/rename_item.png"));

		updateState(viewer.getSelection());
		viewer.addSelectionChangedListener(this);
	}

	private void updateState(ISelection selection) {
		Object obj = null;

		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			if (structuredSelection.size() == 1) {
				obj = structuredSelection.getFirstElement();
			}
		}

		if (obj instanceof Item) {
			setEnabled(true);
			item = (Item) obj;
		} else {
			setEnabled(false);
			item = null;
		}
	}

	public void selectionChanged(SelectionChangedEvent event) {
		updateState(event.getSelection());
	}

	public void run() {
		if (item != null) {
			ProjectView projectView = UIUtil.findView(window.getActivePage(), ProjectView.ID);
			if (projectView != null) {
				projectView.editName(item);
			}
		}
	}

}
