/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.swt.widgets.Display;

public class IntervalTask implements Runnable {

	private final Display _display;

	private final int _interval;

	private final Runnable _task;

	private final AtomicBoolean _scheduled = new AtomicBoolean();

	private long _lastTime;


	protected IntervalTask(Display display, int interval) {
		_display = display;
		_interval = interval;
		_task = this;
	}

	public IntervalTask(Display display, int interval, Runnable task) {
		_display = display;
		_interval = interval;
		_task = task;
	}

	public void schedule() {
		if (!_display.isDisposed() && _scheduled.compareAndSet(false, true)) {
			_display.asyncExec(_taskTimer);
		}
	}

	private final Runnable _taskTimer = new Runnable() {
		public void run() {
			int delay = (int) Math.max(0, _interval - (System.nanoTime() - _lastTime) / 1000000);
			if (delay == 0) {
				_taskRunner.run();
			} else {
				_display.timerExec(delay, _taskRunner);
			}
		}
	};

	private final Runnable _taskRunner = new Runnable() {
		public void run() {
			_scheduled.set(false);
			_lastTime = System.nanoTime();
			_task.run();
		}
	};

	public void run() {
	}

}
