/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.sunfish.javapp.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jp.gr.java_conf.sunfish.javapp.JavapExecute;
import jp.gr.java_conf.sunfish.javapp.JavappPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaCore;

public class ClassFileStorage
implements IStorage {
    private IFile file;

    public ClassFileStorage(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public InputStream getContents() throws CoreException {
        String pluginId = JavappPlugin.getDefault().getBundle().getSymbolicName();
        IJavaProject project = JavaCore.create((IProject)this.file.getProject());
        if (!project.exists()) {
            throw new CoreException((IStatus)new Status(4, pluginId, 4, "This is not java project.", null));
        }
        String fileName = this.file.getName();
        String wsPath = this.file.getWorkspace().getRoot().getLocation().toOSString();
        String outputPath = project.getOutputLocation().toOSString();
        IPackageDeclaration[] pac = JavaCore.createCompilationUnitFrom((IFile)this.file).getPackageDeclarations();
        String packName = pac.length == 0 ? "" : String.valueOf(pac[0].getElementName()) + '.';
        String classpath = String.valueOf(wsPath) + outputPath;
        String classname = String.valueOf(packName) + fileName.substring(0, fileName.length() - 5);
        IPreferencesService service = Platform.getPreferencesService();
        String path = service.getString(pluginId, "javapp.pref.path", "", null);
        boolean isBackward = service.getBoolean(pluginId, "javapp.pref.isBackward", false, null);
        boolean isCode = service.getBoolean(pluginId, "javapp.pref.isCode", true, null);
        boolean isLine = service.getBoolean(pluginId, "javapp.pref.isLine", true, null);
        boolean isPublic = service.getBoolean(pluginId, "javapp.pref.isPublic", false, null);
        boolean isProtected = service.getBoolean(pluginId, "javapp.pref.isProtected", false, null);
        boolean isPackage = service.getBoolean(pluginId, "javapp.pref.isPackage", false, null);
        boolean isPrivate = service.getBoolean(pluginId, "javapp.pref.isPrivate", true, null);
        boolean isSignature = service.getBoolean(pluginId, "javapp.pref.isSignature", true, null);
        boolean isVerbose = service.getBoolean(pluginId, "javapp.pref.isVerbose", true, null);
        JavapExecute exec = new JavapExecute(path);
        String result = exec.exec(classpath, classname, isBackward, isCode, isLine, isPublic, isProtected, isPackage, isPrivate, isSignature, isVerbose);
        return new ByteArrayInputStream(result.getBytes());
    }

    public IPath getFullPath() {
        return this.file.getFullPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

