package org.dyndns.nuda.tools.regex.plugins.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.logger.LoggerAdaptorInjection;
import org.dyndns.nuda.plugin.PluginDescription;
import org.dyndns.nuda.tools.regex.annotation.RegexItem;
import org.dyndns.nuda.tools.regex.plugins.CachePlugin;
import org.dyndns.nuda.tools.regex.reflection.cache.CacheManager;
import org.dyndns.nuda.tools.regex.reflection.cache.FieldCache;
import org.dyndns.nuda.tools.regex.reflection.cache.MethodCache;
import org.dyndns.nuda.tools.regex.reflection.cache.TargetFieldCache;
import org.dyndns.nuda.tools.util.ReflectUtil;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;

/**
 * フィールドキャッシュについては、インメモリの方が高速のため
 * ペンディング
 * @author koseki
 *
 */
@PluginDescription(name="MemcachedCache")
public class MemcachedCache implements CachePlugin, FieldCache, MethodCache {
	// ロガー

	@LoggerAdaptorInjection(name = "MemcachedCacheManager")
	private static LoggerAdaptor logger;

	private static MemCachedClient client = null;

	private static final String MEMCACHED_REGEX_CACHE_PREFIX = "org.dyndns.nuda.tools.regex.plugins.cache.MemcachedCache";

	@Override
	public void init() {
		logger.debug("プラグイン初期化[{}]", "Memcached-Cache-Pluginは有効です");
		
		CacheManager.setFieldCache(this);

		SockIOPool pool = SockIOPool.getInstance();
		pool.setServers(new String[] { "localhost:11211" });
		pool.initialize();

		logger.info("次のアドレスのmemcachedクライアントに接続しました[{}:{}]", "localhost",
				"11211");

		client = new MemCachedClient();
	}

	public Map<Integer, List<Field>> getTargetFieldList(Class<?> targetClass) {
		if (targetClass == null) {
			return new HashMap<Integer, List<Field>>();
		}
		if(client != null) {
			String key = MEMCACHED_REGEX_CACHE_PREFIX + "___"
					+ targetClass.getCanonicalName();
			Object obj = client.get(key);
			if (obj != null) {
				try {
					@SuppressWarnings("unchecked")
					Map<Integer, List<String>> result = (Map<Integer, List<String>>)obj;
					Map<Integer, List<Field>> mapResult = new HashMap<Integer, List<Field>>();
					
					for(Entry<Integer, List<String>> entry : result.entrySet()) {
						Integer k = entry.getKey();
						List<String> v = entry.getValue();
						
						List<Field> fieldList = new ArrayList<Field>();
						for(String fName : v) {
							Field aField = targetClass.getDeclaredField(fName);
							fieldList.add(aField);
						}
						mapResult.put(k, fieldList);
					}
					logger.info("クラス[{}]のフィールドリストがキャッシュ内にヒットしました", targetClass.getCanonicalName());
					return mapResult;
				} catch(Exception e) {
					logger.error("エラーコード:{} 管理者へ連絡してください", "Z-00001");
					return TargetFieldCache.getInstance().getTargetFieldList(targetClass);
				}

				
			} else {
				List<Field> fields = ReflectUtil.getAnnotationPresentedField(
						targetClass, RegexItem.class);

				Map<Integer, List<Field>> fieldMap = new HashMap<Integer, List<Field>>();
				Map<Integer, List<String>> cachedFieldMap = new HashMap<Integer, List<String>>();
				for (Field f : fields) {
					int groupIndex = f.getAnnotation(RegexItem.class).groupIndex();

					List<Field> fieldList = null;
					List<String> cachedFieldList = null;
					if (fieldMap.containsKey(groupIndex)) {
						
						fieldList = fieldMap.get(groupIndex);
						cachedFieldList = cachedFieldMap.get(groupIndex);
					} else {
						fieldList = new ArrayList<Field>();
						cachedFieldList = new ArrayList<String>();
						fieldMap.put(groupIndex, fieldList);
						cachedFieldMap.put(groupIndex, cachedFieldList);
					}
					fieldList.add(f);
					cachedFieldList.add(f.getName());
					// fieldMap.put(groupIndex, f);
				}
				//aCache.put(targetClass, fieldMap);
				//client.set(key, fieldMap);
				client.set(key, cachedFieldMap);
				
				return fieldMap;
			}
		} else {
			//throw new RuntimeException("memcachedクライアントが存在しません");
			logger.error("メッセージ:{} / エラーコード:{} 管理者へ連絡してください", "memcachedクライアントが存在しません", "Z-00001");
			return TargetFieldCache.getInstance().getTargetFieldList(targetClass);
		}

	}

	public Map<Integer, List<Method>> createPreProcessor(Class<?> targetClass) {
		return null;
	}

	public Map<Integer, List<Method>> createPostProcessor(Class<?> targetClass) {
		return null;
	}
}
