package org.dyndns.nuda.tools.regex.plugins.cache;

import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.tools.regex.settings.JAutoRegexerSettingRepository;
import org.dyndns.nuda.tools.regex.settings.JAutoRegexerSettings;


public class DefaultMemcachedServerSettings implements
		JAutoRegexerSettings {

	private static LoggerAdaptor logger = CommonLogger.getLoggerAdaptor().getLogger("JAutoRegexerSettingInfo");
	
	@Override
	public Object getSetting(String settingKey) {
		if(MemcachedRegexCache.SERVER_INFO_PROPERTY_KEY.equals(settingKey)) {
			return new String[]{"localhost:11211", "localhost:11212"};
		}
		return null;
	}

	@Override
	public void init() {
		logger.debug("JAutoRegexer設定情報:[{}]をロードしました", this.getClass().getCanonicalName());
		JAutoRegexerSettingRepository.addSetting(this);
	}

}
