package org.dyndns.nuda.tools.regex.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 正規表現解析Beanに対して付与するアノテーションです
 * 
 * @author nkoseki
 * 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface Regex {
	
	/**
	 * 正規表現パターンを表します
	 * 
	 * @return
	 */
	public String pattern();
	
	/**
	 * Pattern.MULTILINEを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isMultiLine() default false;
	
	/**
	 * Pattern.DOTALLを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isDoTall() default false;
	
	/**
	 * Pattern.COMMENTSを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isComments() default false;
	
	/**
	 * Pattern.CASE_INSENSITIVEを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isCaseInsentive() default false;
	
	/**
	 * Pattern.LITERALを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isLiteral() default false;
	
	/**
	 * Pattern.UNIX_LINESを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isUnixLines() default false;
	
	/**
	 * Pattern.UNICODE_CASEを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isUnicodeCase() default false;
	
	/**
	 * Pattern.CANON_EQを指定するかを表すフラグです
	 * 
	 * @return
	 */
	public boolean isCanonEq() default false;
}
