package org.jboss.seam.example.contactlist.session;

import javax.ejb.Remove;
import javax.ejb.Stateful;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.log.Log;
import org.jboss.seam.faces.FacesMessages;
import org.hibernate.validator.Length;

@Stateful 
@Name("newForm")
public class NewFormBean implements NewForm {

    @Logger private Log log;
    
    @In FacesMessages facesMessages;
    
    private String value;
	
    public void newForm()
	 {
        //implement your business logic here
        log.info("newForm.newForm() action called with: #{newForm.value}");
        facesMessages.add("newForm #{newForm.value}");
	 }
	
	 //add additional action methods
	
    @Length(max=10)
    public String getValue()
    {
        return value;
    }

    public void setValue(String value)
    {
        this.value = value;
    }

    @Destroy @Remove                                                                      
    public void destroy() {}
    
}
