package org.jboss.seam.example.contactlist.session;

import org.jboss.seam.example.contactlist.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("contactList")
public class ContactList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(contact.address) like concat(lower(#{contactList.contact.address}),'%')",
			"lower(contact.businessPhone) like concat(lower(#{contactList.contact.businessPhone}),'%')",
			"lower(contact.cellPhone) like concat(lower(#{contactList.contact.cellPhone}),'%')",
			"lower(contact.city) like concat(lower(#{contactList.contact.city}),'%')",
			"lower(contact.country) like concat(lower(#{contactList.contact.country}),'%')",
			"lower(contact.firstName) like concat(lower(#{contactList.contact.firstName}),'%')",
			"lower(contact.homePhone) like concat(lower(#{contactList.contact.homePhone}),'%')",
			"lower(contact.lastName) like concat(lower(#{contactList.contact.lastName}),'%')",
			"lower(contact.state) like concat(lower(#{contactList.contact.state}),'%')",
			"lower(contact.zip) like concat(lower(#{contactList.contact.zip}),'%')",};

	private Contact contact = new Contact();

	@Override
	public String getEjbql() {
		return "select contact from Contact contact";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Contact getContact() {
		return contact;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
