package org.jboss.seam.example.contactlist.session;

import org.jboss.seam.example.contactlist.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("commentList")
public class CommentList extends EntityQuery {

	private static final String[] RESTRICTIONS = {"lower(comment.text) like concat(lower(#{commentList.comment.text}),'%')",};

	private Comment comment = new Comment();

	@Override
	public String getEjbql() {
		return "select comment from Comment comment";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Comment getComment() {
		return comment;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
