package org.jboss.seam.example.contactlist.session;

import org.jboss.seam.example.contactlist.*;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityHome;

@Name("commentHome")
public class CommentHome extends EntityHome<Comment> {

	@In(create = true)
	ContactHome contactHome;

	public void setCommentId(Long id) {
		setId(id);
	}

	public Long getCommentId() {
		return (Long) getId();
	}

	@Override
	protected Comment createInstance() {
		Comment comment = new Comment();
		return comment;
	}

	public void wire() {
		Contact contact = contactHome.getDefinedInstance();
		if (contact != null) {
			getInstance().setContact(contact);
		}
	}

	public boolean isWired() {
		return true;
	}

	public Comment getDefinedInstance() {
		return isIdDefined() ? getInstance() : null;
	}

}
