if (!window.Richfaces) { window.Richfaces = {}; }

Richfaces.SelectItem = Class.create();

Richfaces.SelectItem.prototype = {
	initialize : function(label, id, node) {
		this._label = label;
		this._node = node; 
		
		this._node.item = this;
		this._id = id;
		
		//TODO 2 optimize
		this.input = $(node.id + "StateInput");
		
		this.selected = /^s/.test(this.input.value);
		this.active = /^s?a/.test(this.input.value);
	},
	
	doActive : function() {
		var classes = this.CLASSES; 
		var row = this._node;

		this.addClass(row, classes.ROW.ACTIVE, classes.CELL.ACTIVE);

		this.active = true;
	},
	
	doSelect : function() {
		var row = this._node;
		var classes = this.CLASSES; 

		this.addClass(row, classes.ROW.SELECTED, classes.CELL.SELECTED);
		this.removeClass(row, classes.ROW.ACTIVE, classes.CELL.ACTIVE);

		this.selected = true;
	},
	
	doNormal : function() {
		var row = this._node;
		var classes = this.CLASSES; 

		this.removeClass(row, classes.ROW.SELECTED, classes.CELL.SELECTED);
		this.removeClass(row, classes.ROW.ACTIVE, classes.CELL.ACTIVE);

		this.active = false;
		this.selected = false;
	},
	
	isSelected : function() {
		return this.selected;
	},
	
	isActive : function() {
		return this.active;
	},
	
	addClass : function(row, classNameRow, classNameCell) {
		if (row.addClassName) {
			row.addClassName(classNameRow);
		} else {
			Element.addClassName(row, classNameRow);
		}
		
		var cells = row.cells;
		for (var i = 0; i < cells.length; i++) {
			var cell = cells[i];
			
			if (cell.addClassName) {
				cell.addClassName(classNameCell);
			} else {
				Element.addClassName(cell, classNameCell);
			}
		}
	},
	
	removeClass : function(row, classNameRow, classNameCell) {
		if (row.removeClassName) {
			row.removeClassName(classNameRow);
		} else {
			Element.removeClassName(row, classNameRow);
		}

		var cells = row.cells;
		for (var i = 0; i < cells.length; i++) {
			var cell = cells[i];
			
			if (cell.removeClassName) {
				cell.removeClassName(classNameCell);
			} else {
				Element.removeClassName(cell, classNameCell);
			}
		}
	},
	
	saveState: function() {
		var regex = /^s?a?/;
		
		if (this.selected && this.active) {
			this.input.value = this.input.value.replace(regex, 'sa');
		} else if (this.selected) {
			this.input.value = this.input.value.replace(regex, 's');
		} else if (this.active) {
			this.input.value = this.input.value.replace(regex, 'a');
		} else {
			this.input.value = this.input.value.replace(regex, '');
		}
	}
}
