/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.util.BitSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;

public class DeleteOperation
extends AbstractBatchOperation {
    DeleteOperation() {
        this._reverseRowOrder = true;
    }

    protected ITableIterator iterator(IDataSet dataSet) throws DatabaseUnitException {
        return dataSet.reverseIterator();
    }

    public OperationData getOperationData(ITableMetaData metaData, BitSet ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        Column[] primaryKeys = metaData.getPrimaryKeys();
        if (primaryKeys.length == 0) {
            throw new NoPrimaryKeyException(metaData.getTableName());
        }
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("delete from ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        sqlBuffer.append(" where ");
        int i = 0;
        while (i < primaryKeys.length) {
            String columnName = this.getQualifiedName(null, primaryKeys[i].getColumnName(), connection);
            sqlBuffer.append(columnName);
            sqlBuffer.append(" = ?");
            if (i + 1 < primaryKeys.length) {
                sqlBuffer.append(" and ");
            }
            ++i;
        }
        return new OperationData(sqlBuffer.toString(), primaryKeys);
    }
}

