/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableIterator;

public class SequenceTableFilter
implements ITableFilter {
    private final String[] _tableNames;

    public SequenceTableFilter(String[] tableNames) {
        this._tableNames = tableNames;
    }

    private boolean accept(String tableName, String[] tableNames, boolean verifyDuplicate) throws AmbiguousTableNameException {
        boolean found = false;
        int i = 0;
        while (i < tableNames.length) {
            if (tableName.equalsIgnoreCase(tableNames[i])) {
                if (!verifyDuplicate) {
                    return true;
                }
                if (found) {
                    throw new AmbiguousTableNameException(tableName);
                }
                found = true;
            }
            ++i;
        }
        return found;
    }

    public boolean accept(String tableName) throws DataSetException {
        return this.accept(tableName, this._tableNames, true);
    }

    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < this._tableNames.length) {
            try {
                ITableMetaData metaData = dataSet.getTableMetaData(this._tableNames[i]);
                nameList.add(metaData.getTableName());
            }
            catch (NoSuchTableException e) {
                // empty catch block
            }
            ++i;
        }
        return nameList.toArray(new String[0]);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        String[] tableNames = this.getTableNames(dataSet);
        return new SequenceTableIterator(reversed ? DataSetUtils.reverseStringArray(tableNames) : tableNames, dataSet);
    }
}

