/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.ITableFilter;

public abstract class AbstractTableFilter
implements ITableFilter {
    public abstract boolean isValidName(String var1) throws DataSetException;

    public boolean accept(String tableName) throws DataSetException {
        return this.isValidName(tableName);
    }

    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        String[] tableNames = dataSet.getTableNames();
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < tableNames.length) {
            String tableName = tableNames[i];
            if (this.accept(tableName)) {
                nameList.add(tableName);
            }
            ++i;
        }
        return nameList.toArray(new String[0]);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        return new FilterIterator(reversed ? dataSet.reverseIterator() : dataSet.iterator());
    }

    private class FilterIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public FilterIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            while (this._iterator.next()) {
                if (!AbstractTableFilter.this.accept(this._iterator.getTableMetaData().getTableName())) continue;
                return true;
            }
            return false;
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            return this._iterator.getTable();
        }
    }
}

