/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;

public abstract class AbstractTableMetaData
implements ITableMetaData {
    private static final Column[] EMPTY_COLUMNS = new Column[0];

    protected static Column[] getPrimaryKeys(Column[] columns, String[] keyNames) {
        if (keyNames == null || keyNames.length == 0) {
            return EMPTY_COLUMNS;
        }
        ArrayList<Column> keyList = new ArrayList<Column>();
        int i = 0;
        while (i < keyNames.length) {
            Column primaryKey = DataSetUtils.getColumn(keyNames[i], columns);
            if (primaryKey != null) {
                keyList.add(primaryKey);
            }
            ++i;
        }
        return keyList.toArray(new Column[0]);
    }

    protected static Column[] getPrimaryKeys(String tableName, Column[] columns, IColumnFilter columnFilter) {
        ArrayList<Column> keyList = new ArrayList<Column>();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (columnFilter.accept(tableName, column)) {
                keyList.add(column);
            }
            ++i;
        }
        return keyList.toArray(new Column[0]);
    }

    public abstract Column[] getPrimaryKeys() throws DataSetException;

    public abstract Column[] getColumns() throws DataSetException;

    public abstract String getTableName();
}

