/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.QuerySet;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvDataSetWriter;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlWriter;
import org.dbunit.dataset.xml.XmlDataSet;

public class Export
extends AbstractStep {
    private File _dest;
    private String _format = "flat";
    private String _doctype = null;
    private List _tables = new ArrayList();

    private String getAbsolutePath(File filename) {
        return filename != null ? filename.getAbsolutePath() : "null";
    }

    public File getDest() {
        return this._dest;
    }

    public String getFormat() {
        return this._format;
    }

    public List getTables() {
        return this._tables;
    }

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void setFormat(String format) {
        if (!(format.equalsIgnoreCase("flat") || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("dtd") || format.equalsIgnoreCase("csv"))) {
            throw new IllegalArgumentException("Type must be one of: 'flat'(default), 'xml', or 'dtd' but was: " + format);
        }
        this._format = format;
    }

    public void addTable(Table table) {
        this._tables.add(table);
    }

    public void addQuery(Query query) {
        this._tables.add(query);
    }

    public void addQuerySet(QuerySet querySet) {
        this._tables.add(querySet);
    }

    public String getDoctype() {
        return this._doctype;
    }

    public void setDoctype(String doctype) {
        this._doctype = doctype;
    }

    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        block11: {
            try {
                if (this._dest == null) {
                    throw new DatabaseUnitException("'_dest' is a required attribute of the <export> step.");
                }
                IDataSet dataset = this.getDatabaseDataSet(connection, this._tables, false);
                this.log("dataset tables: " + Arrays.asList(dataset.getTableNames()), 3);
                if (this._format.equals("csv")) {
                    CsvDataSetWriter.write(dataset, this._dest);
                    break block11;
                }
                FileOutputStream out = new FileOutputStream(this._dest);
                try {
                    if (this._format.equalsIgnoreCase("flat")) {
                        FlatXmlWriter writer = new FlatXmlWriter(out);
                        writer.setDocType(this._doctype);
                        writer.write(dataset);
                    } else if (this._format.equalsIgnoreCase("xml")) {
                        XmlDataSet.write(dataset, out);
                    } else if (this._format.equalsIgnoreCase("dtd")) {
                        FlatDtdDataSet.write(dataset, out);
                    }
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                ((OutputStream)out).close();
                {
                }
            }
            catch (IOException e) {
                throw new DatabaseUnitException(e);
            }
        }
    }

    public String getLogMessage() {
        return "Executing export: \n      in format: " + this._format + " to datafile: " + this.getAbsolutePath(this._dest);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Export: ");
        result.append(" dest=" + this.getAbsolutePath(this._dest));
        result.append(", format= " + this._format);
        result.append(", doctype= " + this._doctype);
        result.append(", tables= " + this._tables);
        return result.toString();
    }
}

