/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.sql.Connection;
import java.sql.DriverManager;
import org.dbunit.AbstractDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;

public class JdbcDatabaseTester
extends AbstractDatabaseTester {
    private String connectionUrl;
    private String driverClass;
    private boolean initialized = false;
    private String password;
    private String username;

    public JdbcDatabaseTester(String driverClass, String connectionUrl) {
        this(driverClass, connectionUrl, null, null);
    }

    public JdbcDatabaseTester(String driverClass, String connectionUrl, String username, String password) {
        this.driverClass = driverClass;
        this.connectionUrl = connectionUrl;
        this.username = username;
        this.password = password;
    }

    public IDatabaseConnection getConnection() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        this.assertNotNullNorEmpty("connectionUrl", this.connectionUrl);
        Connection conn = null;
        conn = this.username == null && this.password == null ? DriverManager.getConnection(this.connectionUrl) : DriverManager.getConnection(this.connectionUrl, this.username, this.password);
        if (this.getSchema() != null) {
            return new DatabaseConnection(conn, this.getSchema());
        }
        return new DatabaseConnection(conn);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    protected void initialize() throws Exception {
        this.assertNotNullNorEmpty("driverClass", this.driverClass);
        Class.forName(this.driverClass);
        this.initialized = true;
    }

    protected void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    protected void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }
}

