/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.userapi;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.buni.meldware.mail.MailListenerChain;
import org.buni.meldware.mail.mailbox.Alias;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.FolderSummary;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.message.Body;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.Message;
import org.buni.meldware.mail.userapi.MailSender;
import org.buni.meldware.mail.util.Node;
import org.buni.meldware.mail.util.io.SimpleCopier;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSenderImpl
implements MailSender,
Advised {
    MailListenerChain chain;
    MailBodyManager bm;
    MailboxService mailboxService;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.userapi.MailSenderImpl"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getMailForFolder_N_7478805970043410941;
    private static WeakReference aop$MethodInfo_send_N_6655118784284662624;
    private static WeakReference aop$MethodInfo_walkPath8040802422362798717;
    private static WeakReference aop$MethodInfo_getMailBody_N_1063027204338369520;
    private static WeakReference aop$MethodInfo_getMailAttachmentFilename1580451619062401672;
    private static WeakReference aop$MethodInfo_getMailAttachment7245488729256644659;
    private static WeakReference aop$MethodInfo_getMailLength_N_3966669888339889771;
    private static WeakReference aop$MethodInfo_deleteMail_N_4375880614454499194;
    private static WeakReference aop$MethodInfo_createFolder_N_6927082626046967362;
    private static WeakReference aop$MethodInfo_deleteFolder_N_2387357067219096445;
    private static WeakReference aop$MethodInfo_moveFolder_N_2258868246642069181;
    private static WeakReference aop$MethodInfo_save_N_2841676496229194195;
    private static WeakReference aop$MethodInfo_getAliases7896895568457778935;
    private static WeakReference aop$MethodInfo_moveMail_N_1213845183626713609;

    @Override
    public void setListenerChain(MailListenerChain chain) {
        this.chain = chain;
    }

    @Override
    public MailListenerChain getListenerChain() {
        return this.chain;
    }

    @Override
    public void setBodyManager(MailBodyManager mgr) {
        this.bm = mgr;
    }

    @Override
    public MailBodyManager getBodyManager() {
        return this.bm;
    }

    @Override
    public void setMailboxManager(MailboxService mbm) {
        this.mailboxService = mbm;
    }

    @Override
    public MailboxService getMailboxManager() {
        return this.mailboxService;
    }

    @Override
    public Node<FolderSummary> folderSummary(String user) {
        return this.mailboxService.folderSummary(user);
    }

    @Tx(value=TxType.REQUIRED)
    public List<MessageData> org$buni$meldware$mail$userapi$MailSenderImpl$getMailForFolder$aop(String user, String foldername) {
        String[] path;
        List<MessageData> retval = null;
        Mailbox box = this.mailboxService.getMailboxByAlias(user);
        Folder folder = this.walkPath((Folder)box, path = foldername.split("/"), 0);
        if (folder != null) {
            retval = this.mailboxService.getMailListForFolder(folder, true);
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$userapi$MailSenderImpl$send$aop(String alias, String from, String[] to, String[] cc, String[] bcc, String subject, String body) {
        Mail mail = Mail.create((MailBodyManager)this.bm, (String)from, (String[])to, (String[])cc, (String[])bcc, (String)subject, (String)body);
        this.chain.processMail((Message)mail);
        if (alias != null) {
            Mailbox box = this.mailboxService.getMailboxByAlias(alias);
            Folder f = box.getDefaultOutFolder();
            String path = this.mailboxService.getPathFor(f);
            this.save(alias, path, from, to, cc, bcc, subject, body);
        }
        return 0;
    }

    @Tx(value=TxType.REQUIRED)
    private Folder org$buni$meldware$mail$userapi$MailSenderImpl$walkPath$aop(Folder folder, String[] path, int i) {
        Folder f = folder;
        if (i < path.length && (f = this.mailboxService.getSubfolderByName(folder, path[i])) != null) {
            return this.walkPath(f, path, i + 1);
        }
        return f;
    }

    @Tx(value=TxType.REQUIRED)
    public String org$buni$meldware$mail$userapi$MailSenderImpl$getMailBody$aop(long uid, long firstbyte, long lastbyte) {
        String retval = null;
        try {
            MessageData data = this.mailboxService.getMail(uid);
            List<Body> bodies = this.mailboxService.getMailBody(data);
            Body body = bodies.get(0);
            BufferedInputStream stream = new BufferedInputStream(this.bm.getInputStream(body));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (firstbyte > 0L) {
                ((InputStream)stream).skip(firstbyte);
            }
            SimpleCopier c = new SimpleCopier();
            c.copy(stream, out, 4096);
            ((InputStream)stream).close();
            retval = new String(out.toByteArray(), "US-ASCII");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public List<String> org$buni$meldware$mail$userapi$MailSenderImpl$getMailAttachmentFilename$aop(long uid) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            MessageData data = this.mailboxService.getMail(uid);
            List<Body> bodies = this.mailboxService.getMailBody(data);
            if (bodies.size() < 2) {
                return retval;
            }
            Pattern p = Pattern.compile("filename=\"(.+)\"");
            int i = 1;
            while (i < bodies.size()) {
                MessageBody messageBody = this.mailboxService.getMessageBody(data, i);
                String mimeheader = messageBody.getMimeheader();
                Matcher m = p.matcher(mimeheader);
                if (m.find()) {
                    retval.add(m.group(1));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public InputStream org$buni$meldware$mail$userapi$MailSenderImpl$getMailAttachment$aop(long uid, String filename) {
        List<Body> bodies;
        MessageData data;
        block5: {
            data = this.mailboxService.getMail(uid);
            bodies = this.mailboxService.getMailBody(data);
            if (bodies.size() >= 2) break block5;
            return null;
        }
        try {
            Pattern p = Pattern.compile("filename=\"" + filename + "\"");
            int i = 1;
            while (i < bodies.size()) {
                MessageBody messageBody = this.mailboxService.getMessageBody(data, i);
                String mimeheader = messageBody.getMimeheader();
                Matcher m = p.matcher(mimeheader);
                if (m.find()) {
                    return this.bm.getStore().getStoreItem(messageBody.getBodyId()).getInputStream();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    @Tx(value=TxType.REQUIRED)
    public long org$buni$meldware$mail$userapi$MailSenderImpl$getMailLength$aop(long uid) {
        return this.mailboxService.getMail(uid).getSize();
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$userapi$MailSenderImpl$deleteMail$aop(String user, long uid, boolean forReal, boolean trash) {
        MessageData data = this.mailboxService.getMail(uid);
        if (!forReal) {
            if (trash) {
                Mailbox box = this.mailboxService.getMailboxByAlias(user);
                Folder trashFolder = this.mailboxService.getSubfolderByName((Folder)box, "Trash");
                this.mailboxService.copy(data, data.getFolder(), trashFolder);
            }
            data.setDeleted(true);
            this.mailboxService.updateMessageMetaData(data);
        } else {
            if (trash) {
                Mailbox box = this.mailboxService.getMailboxByAlias(user);
                Folder trashFolder = this.mailboxService.getSubfolderByName((Folder)box, "Trash");
                this.mailboxService.copy(data, data.getFolder(), trashFolder);
            }
            this.mailboxService.deleteMessage(uid);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$userapi$MailSenderImpl$createFolder$aop(String alias, String path) {
        Mailbox box = this.mailboxService.getMailboxByAlias(alias);
        String[] apath = path.split("/");
        Mailbox parent = box;
        Folder retval = null;
        if (apath.length > 1) {
            String[] tpath = new String[apath.length - 1];
            System.arraycopy(apath, 0, tpath, 0, tpath.length);
            parent = this.mailboxService.getSubfolderByPath((Folder)box, tpath);
            retval = this.mailboxService.createFolder((Folder)parent, apath[apath.length - 1]);
        } else {
            retval = this.mailboxService.createFolder((Folder)parent, apath[0]);
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$userapi$MailSenderImpl$deleteFolder$aop(String alias, String path) {
        Mailbox box = this.mailboxService.getMailboxByAlias(alias);
        String[] apath = path.split("/");
        Folder folder = null;
        folder = this.mailboxService.getSubfolderByPath((Folder)box, apath);
        this.mailboxService.deleteFolder(folder);
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$userapi$MailSenderImpl$moveFolder$aop(String alias, String foldername, String targetname) {
        Mailbox box = this.mailboxService.getMailboxByAlias(alias);
        String[] spath = foldername.split("/");
        String[] tpath = targetname.split("/");
        String newname = tpath[tpath.length - 1];
        Folder source = this.mailboxService.getSubfolderByPath((Folder)box, spath);
        Mailbox target = tpath.length > 1 ? this.mailboxService.getSubfolderByPath((Folder)box, MailSenderImpl.parent(tpath)) : box;
        Folder retval = this.mailboxService.moveFolder(source, (Folder)target, newname);
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageData org$buni$meldware$mail$userapi$MailSenderImpl$save$aop(String alias, String foldername, String from, String[] to, String[] cc, String[] bcc, String subject, String body) {
        Mailbox box = this.mailboxService.getMailboxByAlias(alias);
        String tfoldername = foldername.startsWith("/") ? foldername.substring(1) : foldername;
        String[] path = tfoldername.split("/");
        Mail m = Mail.create((MailBodyManager)this.bm, (String)from, (String[])to, (String[])cc, (String[])bcc, (String)subject, (String)body);
        MessageData data = new MessageData(m);
        data.setSeen(false);
        Folder folder = this.mailboxService.getSubfolderByPath((Folder)box, path);
        this.mailboxService.createMail(folder, data);
        return data;
    }

    @Tx(value=TxType.REQUIRED)
    public List<String> org$buni$meldware$mail$userapi$MailSenderImpl$getAliases$aop(String user) {
        Mailbox box = this.mailboxService.getMailboxByAlias(user);
        if (box == null) {
            return new ArrayList<String>();
        }
        Collection a = box.getAliases();
        ArrayList<String> l = new ArrayList<String>(a.size());
        for (Alias alias : a) {
            l.add(alias.getName());
        }
        return l;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageData org$buni$meldware$mail$userapi$MailSenderImpl$moveMail$aop(String alias, String targetname, long uid) {
        Mailbox box = this.mailboxService.getMailboxByAlias(alias);
        String[] trgpath = targetname.split("/");
        Folder target = this.mailboxService.getSubfolderByPath((Folder)box, trgpath);
        MessageData data = this.mailboxService.getMail(uid);
        data.setFolder(target);
        this.mailboxService.updateMessageMetaData(data);
        return data;
    }

    private static final String[] parent(String[] path) {
        if (path.length < 2) {
            return new String[]{""};
        }
        String[] retval = new String[path.length - 1];
        System.arraycopy(path, 0, retval, 0, retval.length);
        return retval;
    }

    @Override
    public boolean provision(String alias) {
        Mailbox box = this.mailboxService.getMailboxByAlias(alias);
        if (box == null) {
            box = this.mailboxService.createMailbox(alias);
            return false;
        }
        return true;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        MailSenderImpl mailSenderImpl = this;
        synchronized (mailSenderImpl) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        MailSenderImpl mailSenderImpl = this;
        synchronized (mailSenderImpl) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public List getMailForFolder(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailForFolder_N_7478805970043410941.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailForFolder_N7478805970043410941 getMailForFolder_N74788059700434109412 = new getMailForFolder_N7478805970043410941(methodInfo, interceptorArray);
            getMailForFolder_N74788059700434109412.arg0 = string;
            getMailForFolder_N74788059700434109412.arg1 = string2;
            getMailForFolder_N74788059700434109412.setTargetObject(this);
            getMailForFolder_N74788059700434109412.typedTargetObject = this;
            getMailForFolder_N74788059700434109412.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMailForFolder_N74788059700434109412.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$getMailForFolder$aop(string, string2);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int send(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, String string4) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_send_N_6655118784284662624.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            send_N6655118784284662624 send_N66551187842846626242 = new send_N6655118784284662624(methodInfo, interceptorArray);
            send_N66551187842846626242.arg0 = string;
            send_N66551187842846626242.arg1 = string2;
            send_N66551187842846626242.arg2 = stringArray;
            send_N66551187842846626242.arg3 = stringArray2;
            send_N66551187842846626242.arg4 = stringArray3;
            send_N66551187842846626242.arg5 = string3;
            send_N66551187842846626242.arg6 = string4;
            send_N66551187842846626242.setTargetObject(this);
            send_N66551187842846626242.typedTargetObject = this;
            send_N66551187842846626242.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)send_N66551187842846626242.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$send$aop(string, string2, stringArray, stringArray2, stringArray3, string3, string4);
    }

    @Tx(value=TxType.REQUIRED)
    private Folder walkPath(Folder folder, String[] stringArray, int n) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_walkPath8040802422362798717.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            walkPath_8040802422362798717 walkPath_80408024223627987172 = new walkPath_8040802422362798717(methodInfo, interceptorArray);
            walkPath_80408024223627987172.arg0 = folder;
            walkPath_80408024223627987172.arg1 = stringArray;
            walkPath_80408024223627987172.arg2 = n;
            walkPath_80408024223627987172.setTargetObject(this);
            walkPath_80408024223627987172.typedTargetObject = this;
            walkPath_80408024223627987172.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)walkPath_80408024223627987172.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$walkPath$aop(folder, stringArray, n);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public String getMailBody(long l, long l2, long l3) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailBody_N_1063027204338369520.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailBody_N1063027204338369520 getMailBody_N10630272043383695202 = new getMailBody_N1063027204338369520(methodInfo, interceptorArray);
            getMailBody_N10630272043383695202.arg0 = l;
            getMailBody_N10630272043383695202.arg1 = l2;
            getMailBody_N10630272043383695202.arg2 = l3;
            getMailBody_N10630272043383695202.setTargetObject(this);
            getMailBody_N10630272043383695202.typedTargetObject = this;
            getMailBody_N10630272043383695202.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (String)getMailBody_N10630272043383695202.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$getMailBody$aop(l, l2, l3);
    }

    @Tx(value=TxType.REQUIRED)
    public List getMailAttachmentFilename(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailAttachmentFilename1580451619062401672.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailAttachmentFilename_1580451619062401672 getMailAttachmentFilename_15804516190624016722 = new getMailAttachmentFilename_1580451619062401672(methodInfo, interceptorArray);
            getMailAttachmentFilename_15804516190624016722.arg0 = l;
            getMailAttachmentFilename_15804516190624016722.setTargetObject(this);
            getMailAttachmentFilename_15804516190624016722.typedTargetObject = this;
            getMailAttachmentFilename_15804516190624016722.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMailAttachmentFilename_15804516190624016722.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$getMailAttachmentFilename$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public InputStream getMailAttachment(long l, String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailAttachment7245488729256644659.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailAttachment_7245488729256644659 getMailAttachment_72454887292566446592 = new getMailAttachment_7245488729256644659(methodInfo, interceptorArray);
            getMailAttachment_72454887292566446592.arg0 = l;
            getMailAttachment_72454887292566446592.arg1 = string;
            getMailAttachment_72454887292566446592.setTargetObject(this);
            getMailAttachment_72454887292566446592.typedTargetObject = this;
            getMailAttachment_72454887292566446592.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InputStream)getMailAttachment_72454887292566446592.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$getMailAttachment$aop(l, string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public long getMailLength(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailLength_N_3966669888339889771.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailLength_N3966669888339889771 getMailLength_N39666698883398897712 = new getMailLength_N3966669888339889771(methodInfo, interceptorArray);
            getMailLength_N39666698883398897712.arg0 = l;
            getMailLength_N39666698883398897712.setTargetObject(this);
            getMailLength_N39666698883398897712.typedTargetObject = this;
            getMailLength_N39666698883398897712.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)getMailLength_N39666698883398897712.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$getMailLength$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteMail(String string, long l, boolean bl, boolean bl2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteMail_N_4375880614454499194.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteMail_N4375880614454499194 deleteMail_N43758806144544991942 = new deleteMail_N4375880614454499194(methodInfo, interceptorArray);
            deleteMail_N43758806144544991942.arg0 = string;
            deleteMail_N43758806144544991942.arg1 = l;
            deleteMail_N43758806144544991942.arg2 = bl;
            deleteMail_N43758806144544991942.arg3 = bl2;
            deleteMail_N43758806144544991942.setTargetObject(this);
            deleteMail_N43758806144544991942.typedTargetObject = this;
            deleteMail_N43758806144544991942.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteMail_N43758806144544991942.invokeNext();
        } else {
            this.org$buni$meldware$mail$userapi$MailSenderImpl$deleteMail$aop(string, l, bl, bl2);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder createFolder(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createFolder_N_6927082626046967362.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createFolder_N6927082626046967362 createFolder_N69270826260469673622 = new createFolder_N6927082626046967362(methodInfo, interceptorArray);
            createFolder_N69270826260469673622.arg0 = string;
            createFolder_N69270826260469673622.arg1 = string2;
            createFolder_N69270826260469673622.setTargetObject(this);
            createFolder_N69270826260469673622.typedTargetObject = this;
            createFolder_N69270826260469673622.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)createFolder_N69270826260469673622.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$createFolder$aop(string, string2);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteFolder(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteFolder_N_2387357067219096445.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteFolder_N2387357067219096445 deleteFolder_N23873570672190964452 = new deleteFolder_N2387357067219096445(methodInfo, interceptorArray);
            deleteFolder_N23873570672190964452.arg0 = string;
            deleteFolder_N23873570672190964452.arg1 = string2;
            deleteFolder_N23873570672190964452.setTargetObject(this);
            deleteFolder_N23873570672190964452.typedTargetObject = this;
            deleteFolder_N23873570672190964452.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteFolder_N23873570672190964452.invokeNext();
        } else {
            this.org$buni$meldware$mail$userapi$MailSenderImpl$deleteFolder$aop(string, string2);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder moveFolder(String string, String string2, String string3) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_moveFolder_N_2258868246642069181.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            moveFolder_N2258868246642069181 moveFolder_N22588682466420691812 = new moveFolder_N2258868246642069181(methodInfo, interceptorArray);
            moveFolder_N22588682466420691812.arg0 = string;
            moveFolder_N22588682466420691812.arg1 = string2;
            moveFolder_N22588682466420691812.arg2 = string3;
            moveFolder_N22588682466420691812.setTargetObject(this);
            moveFolder_N22588682466420691812.typedTargetObject = this;
            moveFolder_N22588682466420691812.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)moveFolder_N22588682466420691812.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$moveFolder$aop(string, string2, string3);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public MessageData save(String string, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, String string4, String string5) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_save_N_2841676496229194195.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            save_N2841676496229194195 save_N28416764962291941952 = new save_N2841676496229194195(methodInfo, interceptorArray);
            save_N28416764962291941952.arg0 = string;
            save_N28416764962291941952.arg1 = string2;
            save_N28416764962291941952.arg2 = string3;
            save_N28416764962291941952.arg3 = stringArray;
            save_N28416764962291941952.arg4 = stringArray2;
            save_N28416764962291941952.arg5 = stringArray3;
            save_N28416764962291941952.arg6 = string4;
            save_N28416764962291941952.arg7 = string5;
            save_N28416764962291941952.setTargetObject(this);
            save_N28416764962291941952.typedTargetObject = this;
            save_N28416764962291941952.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageData)save_N28416764962291941952.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$save$aop(string, string2, string3, stringArray, stringArray2, stringArray3, string4, string5);
    }

    @Tx(value=TxType.REQUIRED)
    public List getAliases(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getAliases7896895568457778935.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getAliases_7896895568457778935 getAliases_78968955684577789352 = new getAliases_7896895568457778935(methodInfo, interceptorArray);
            getAliases_78968955684577789352.arg0 = string;
            getAliases_78968955684577789352.setTargetObject(this);
            getAliases_78968955684577789352.typedTargetObject = this;
            getAliases_78968955684577789352.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getAliases_78968955684577789352.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$getAliases$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public MessageData moveMail(String string, String string2, long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_moveMail_N_1213845183626713609.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            moveMail_N1213845183626713609 moveMail_N12138451836267136092 = new moveMail_N1213845183626713609(methodInfo, interceptorArray);
            moveMail_N12138451836267136092.arg0 = string;
            moveMail_N12138451836267136092.arg1 = string2;
            moveMail_N12138451836267136092.arg2 = l;
            moveMail_N12138451836267136092.setTargetObject(this);
            moveMail_N12138451836267136092.typedTargetObject = this;
            moveMail_N12138451836267136092.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageData)moveMail_N12138451836267136092.invokeNext();
        }
        return this.org$buni$meldware$mail$userapi$MailSenderImpl$moveMail$aop(string, string2, l);
    }

    public static class getMailForFolder_N7478805970043410941
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public MailSenderImpl typedTargetObject;

        public getMailForFolder_N7478805970043410941(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailForFolder_N7478805970043410941(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailForFolder_N7478805970043410941(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailForFolder_N7478805970043410941() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$getMailForFolder$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getMailForFolder_N7478805970043410941 getMailForFolder_N74788059700434109412 = new getMailForFolder_N7478805970043410941(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailForFolder_N74788059700434109412.arguments = this.arguments;
            ((InvocationBase)getMailForFolder_N74788059700434109412).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailForFolder_N74788059700434109412).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailForFolder_N74788059700434109412).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailForFolder_N74788059700434109412.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailForFolder_N74788059700434109412).targetObject = ((InvocationBase)this).targetObject;
            getMailForFolder_N74788059700434109412.arg0 = this.arg0;
            getMailForFolder_N74788059700434109412.arg1 = this.arg1;
            return getMailForFolder_N74788059700434109412;
        }
    }

    public static class send_N6655118784284662624
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public String[] arg2;
        public String[] arg3;
        public String[] arg4;
        public String arg5;
        public String arg6;
        public MailSenderImpl typedTargetObject;

        public send_N6655118784284662624(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public send_N6655118784284662624(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public send_N6655118784284662624(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public send_N6655118784284662624() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$send$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4, this.arg5, this.arg6));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
            Object object3 = objectArray[2];
            this.arg2 = (String[])object3;
            Object object4 = objectArray[3];
            this.arg3 = (String[])object4;
            Object object5 = objectArray[4];
            this.arg4 = (String[])object5;
            Object object6 = objectArray[5];
            this.arg5 = (String)object6;
            Object object7 = objectArray[6];
            this.arg6 = (String)object7;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[7];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            this.arguments[3] = this.arg3;
            this.arguments[4] = this.arg4;
            this.arguments[5] = this.arg5;
            this.arguments[6] = this.arg6;
            return this.arguments;
        }

        public Invocation copy() {
            send_N6655118784284662624 send_N66551187842846626242 = new send_N6655118784284662624(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            send_N66551187842846626242.arguments = this.arguments;
            ((InvocationBase)send_N66551187842846626242).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)send_N66551187842846626242).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)send_N66551187842846626242).instanceResolver = ((InvocationBase)this).instanceResolver;
            send_N66551187842846626242.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)send_N66551187842846626242).targetObject = ((InvocationBase)this).targetObject;
            send_N66551187842846626242.arg0 = this.arg0;
            send_N66551187842846626242.arg1 = this.arg1;
            send_N66551187842846626242.arg2 = this.arg2;
            send_N66551187842846626242.arg3 = this.arg3;
            send_N66551187842846626242.arg4 = this.arg4;
            send_N66551187842846626242.arg5 = this.arg5;
            send_N66551187842846626242.arg6 = this.arg6;
            return send_N66551187842846626242;
        }
    }

    public static class walkPath_8040802422362798717
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String[] arg1;
        public int arg2;
        public MailSenderImpl typedTargetObject;

        public walkPath_8040802422362798717(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public walkPath_8040802422362798717(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public walkPath_8040802422362798717(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public walkPath_8040802422362798717() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$walkPath$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String[])object2;
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            walkPath_8040802422362798717 walkPath_80408024223627987172 = new walkPath_8040802422362798717(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            walkPath_80408024223627987172.arguments = this.arguments;
            ((InvocationBase)walkPath_80408024223627987172).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)walkPath_80408024223627987172).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)walkPath_80408024223627987172).instanceResolver = ((InvocationBase)this).instanceResolver;
            walkPath_80408024223627987172.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)walkPath_80408024223627987172).targetObject = ((InvocationBase)this).targetObject;
            walkPath_80408024223627987172.arg0 = this.arg0;
            walkPath_80408024223627987172.arg1 = this.arg1;
            walkPath_80408024223627987172.arg2 = this.arg2;
            return walkPath_80408024223627987172;
        }
    }

    public static class getMailBody_N1063027204338369520
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public long arg1;
        public long arg2;
        public MailSenderImpl typedTargetObject;

        public getMailBody_N1063027204338369520(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailBody_N1063027204338369520(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailBody_N1063027204338369520(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailBody_N1063027204338369520() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$getMailBody$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Long)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            new Long(this.arg0);
            new Long(this.arg1);
            new Long(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getMailBody_N1063027204338369520 getMailBody_N10630272043383695202 = new getMailBody_N1063027204338369520(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailBody_N10630272043383695202.arguments = this.arguments;
            ((InvocationBase)getMailBody_N10630272043383695202).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailBody_N10630272043383695202).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailBody_N10630272043383695202).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailBody_N10630272043383695202.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailBody_N10630272043383695202).targetObject = ((InvocationBase)this).targetObject;
            getMailBody_N10630272043383695202.arg0 = this.arg0;
            getMailBody_N10630272043383695202.arg1 = this.arg1;
            getMailBody_N10630272043383695202.arg2 = this.arg2;
            return getMailBody_N10630272043383695202;
        }
    }

    public static class getMailAttachmentFilename_1580451619062401672
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailSenderImpl typedTargetObject;

        public getMailAttachmentFilename_1580451619062401672(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailAttachmentFilename_1580451619062401672(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailAttachmentFilename_1580451619062401672(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailAttachmentFilename_1580451619062401672() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$getMailAttachmentFilename$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getMailAttachmentFilename_1580451619062401672 getMailAttachmentFilename_15804516190624016722 = new getMailAttachmentFilename_1580451619062401672(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailAttachmentFilename_15804516190624016722.arguments = this.arguments;
            ((InvocationBase)getMailAttachmentFilename_15804516190624016722).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailAttachmentFilename_15804516190624016722).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailAttachmentFilename_15804516190624016722).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailAttachmentFilename_15804516190624016722.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailAttachmentFilename_15804516190624016722).targetObject = ((InvocationBase)this).targetObject;
            getMailAttachmentFilename_15804516190624016722.arg0 = this.arg0;
            return getMailAttachmentFilename_15804516190624016722;
        }
    }

    public static class getMailAttachment_7245488729256644659
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public String arg1;
        public MailSenderImpl typedTargetObject;

        public getMailAttachment_7245488729256644659(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailAttachment_7245488729256644659(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailAttachment_7245488729256644659(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailAttachment_7245488729256644659() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$getMailAttachment$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            Object object = objectArray[1];
            this.arg1 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            new Long(this.arg0);
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getMailAttachment_7245488729256644659 getMailAttachment_72454887292566446592 = new getMailAttachment_7245488729256644659(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailAttachment_72454887292566446592.arguments = this.arguments;
            ((InvocationBase)getMailAttachment_72454887292566446592).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailAttachment_72454887292566446592).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailAttachment_72454887292566446592).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailAttachment_72454887292566446592.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailAttachment_72454887292566446592).targetObject = ((InvocationBase)this).targetObject;
            getMailAttachment_72454887292566446592.arg0 = this.arg0;
            getMailAttachment_72454887292566446592.arg1 = this.arg1;
            return getMailAttachment_72454887292566446592;
        }
    }

    public static class getMailLength_N3966669888339889771
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailSenderImpl typedTargetObject;

        public getMailLength_N3966669888339889771(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailLength_N3966669888339889771(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailLength_N3966669888339889771(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailLength_N3966669888339889771() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Long(this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$getMailLength$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getMailLength_N3966669888339889771 getMailLength_N39666698883398897712 = new getMailLength_N3966669888339889771(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailLength_N39666698883398897712.arguments = this.arguments;
            ((InvocationBase)getMailLength_N39666698883398897712).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailLength_N39666698883398897712).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailLength_N39666698883398897712).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailLength_N39666698883398897712.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailLength_N39666698883398897712).targetObject = ((InvocationBase)this).targetObject;
            getMailLength_N39666698883398897712.arg0 = this.arg0;
            return getMailLength_N39666698883398897712;
        }
    }

    public static class deleteMail_N4375880614454499194
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public long arg1;
        public boolean arg2;
        public boolean arg3;
        public MailSenderImpl typedTargetObject;

        public deleteMail_N4375880614454499194(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteMail_N4375880614454499194(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteMail_N4375880614454499194(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteMail_N4375880614454499194() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$deleteMail$aop(this.arg0, this.arg1, this.arg2, this.arg3);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Boolean)objectArray[2];
            this.arg3 = (Boolean)objectArray[3];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[4];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Boolean(this.arg2);
            new Boolean(this.arg3);
            return this.arguments;
        }

        public Invocation copy() {
            deleteMail_N4375880614454499194 deleteMail_N43758806144544991942 = new deleteMail_N4375880614454499194(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteMail_N43758806144544991942.arguments = this.arguments;
            ((InvocationBase)deleteMail_N43758806144544991942).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteMail_N43758806144544991942).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteMail_N43758806144544991942).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteMail_N43758806144544991942.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteMail_N43758806144544991942).targetObject = ((InvocationBase)this).targetObject;
            deleteMail_N43758806144544991942.arg0 = this.arg0;
            deleteMail_N43758806144544991942.arg1 = this.arg1;
            deleteMail_N43758806144544991942.arg2 = this.arg2;
            deleteMail_N43758806144544991942.arg3 = this.arg3;
            return deleteMail_N43758806144544991942;
        }
    }

    public static class createFolder_N6927082626046967362
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public MailSenderImpl typedTargetObject;

        public createFolder_N6927082626046967362(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createFolder_N6927082626046967362(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createFolder_N6927082626046967362(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createFolder_N6927082626046967362() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$createFolder$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            createFolder_N6927082626046967362 createFolder_N69270826260469673622 = new createFolder_N6927082626046967362(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createFolder_N69270826260469673622.arguments = this.arguments;
            ((InvocationBase)createFolder_N69270826260469673622).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createFolder_N69270826260469673622).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createFolder_N69270826260469673622).instanceResolver = ((InvocationBase)this).instanceResolver;
            createFolder_N69270826260469673622.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createFolder_N69270826260469673622).targetObject = ((InvocationBase)this).targetObject;
            createFolder_N69270826260469673622.arg0 = this.arg0;
            createFolder_N69270826260469673622.arg1 = this.arg1;
            return createFolder_N69270826260469673622;
        }
    }

    public static class deleteFolder_N2387357067219096445
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public MailSenderImpl typedTargetObject;

        public deleteFolder_N2387357067219096445(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteFolder_N2387357067219096445(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteFolder_N2387357067219096445(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteFolder_N2387357067219096445() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$deleteFolder$aop(this.arg0, this.arg1);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            deleteFolder_N2387357067219096445 deleteFolder_N23873570672190964452 = new deleteFolder_N2387357067219096445(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteFolder_N23873570672190964452.arguments = this.arguments;
            ((InvocationBase)deleteFolder_N23873570672190964452).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteFolder_N23873570672190964452).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteFolder_N23873570672190964452).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteFolder_N23873570672190964452.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteFolder_N23873570672190964452).targetObject = ((InvocationBase)this).targetObject;
            deleteFolder_N23873570672190964452.arg0 = this.arg0;
            deleteFolder_N23873570672190964452.arg1 = this.arg1;
            return deleteFolder_N23873570672190964452;
        }
    }

    public static class moveFolder_N2258868246642069181
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public String arg2;
        public MailSenderImpl typedTargetObject;

        public moveFolder_N2258868246642069181(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public moveFolder_N2258868246642069181(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public moveFolder_N2258868246642069181(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public moveFolder_N2258868246642069181() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$moveFolder$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
            Object object3 = objectArray[2];
            this.arg2 = (String)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            moveFolder_N2258868246642069181 moveFolder_N22588682466420691812 = new moveFolder_N2258868246642069181(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            moveFolder_N22588682466420691812.arguments = this.arguments;
            ((InvocationBase)moveFolder_N22588682466420691812).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)moveFolder_N22588682466420691812).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)moveFolder_N22588682466420691812).instanceResolver = ((InvocationBase)this).instanceResolver;
            moveFolder_N22588682466420691812.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)moveFolder_N22588682466420691812).targetObject = ((InvocationBase)this).targetObject;
            moveFolder_N22588682466420691812.arg0 = this.arg0;
            moveFolder_N22588682466420691812.arg1 = this.arg1;
            moveFolder_N22588682466420691812.arg2 = this.arg2;
            return moveFolder_N22588682466420691812;
        }
    }

    public static class save_N2841676496229194195
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public String arg2;
        public String[] arg3;
        public String[] arg4;
        public String[] arg5;
        public String arg6;
        public String arg7;
        public MailSenderImpl typedTargetObject;

        public save_N2841676496229194195(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public save_N2841676496229194195(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public save_N2841676496229194195(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public save_N2841676496229194195() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$save$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4, this.arg5, this.arg6, this.arg7);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
            Object object3 = objectArray[2];
            this.arg2 = (String)object3;
            Object object4 = objectArray[3];
            this.arg3 = (String[])object4;
            Object object5 = objectArray[4];
            this.arg4 = (String[])object5;
            Object object6 = objectArray[5];
            this.arg5 = (String[])object6;
            Object object7 = objectArray[6];
            this.arg6 = (String)object7;
            Object object8 = objectArray[7];
            this.arg7 = (String)object8;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[8];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            this.arguments[3] = this.arg3;
            this.arguments[4] = this.arg4;
            this.arguments[5] = this.arg5;
            this.arguments[6] = this.arg6;
            this.arguments[7] = this.arg7;
            return this.arguments;
        }

        public Invocation copy() {
            save_N2841676496229194195 save_N28416764962291941952 = new save_N2841676496229194195(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            save_N28416764962291941952.arguments = this.arguments;
            ((InvocationBase)save_N28416764962291941952).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)save_N28416764962291941952).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)save_N28416764962291941952).instanceResolver = ((InvocationBase)this).instanceResolver;
            save_N28416764962291941952.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)save_N28416764962291941952).targetObject = ((InvocationBase)this).targetObject;
            save_N28416764962291941952.arg0 = this.arg0;
            save_N28416764962291941952.arg1 = this.arg1;
            save_N28416764962291941952.arg2 = this.arg2;
            save_N28416764962291941952.arg3 = this.arg3;
            save_N28416764962291941952.arg4 = this.arg4;
            save_N28416764962291941952.arg5 = this.arg5;
            save_N28416764962291941952.arg6 = this.arg6;
            save_N28416764962291941952.arg7 = this.arg7;
            return save_N28416764962291941952;
        }
    }

    public static class getAliases_7896895568457778935
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailSenderImpl typedTargetObject;

        public getAliases_7896895568457778935(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getAliases_7896895568457778935(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getAliases_7896895568457778935(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getAliases_7896895568457778935() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$getAliases$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getAliases_7896895568457778935 getAliases_78968955684577789352 = new getAliases_7896895568457778935(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getAliases_78968955684577789352.arguments = this.arguments;
            ((InvocationBase)getAliases_78968955684577789352).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getAliases_78968955684577789352).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getAliases_78968955684577789352).instanceResolver = ((InvocationBase)this).instanceResolver;
            getAliases_78968955684577789352.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getAliases_78968955684577789352).targetObject = ((InvocationBase)this).targetObject;
            getAliases_78968955684577789352.arg0 = this.arg0;
            return getAliases_78968955684577789352;
        }
    }

    public static class moveMail_N1213845183626713609
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public long arg2;
        public MailSenderImpl typedTargetObject;

        public moveMail_N1213845183626713609(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public moveMail_N1213845183626713609(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public moveMail_N1213845183626713609(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public moveMail_N1213845183626713609() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$userapi$MailSenderImpl$moveMail$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
            this.arg2 = (Long)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Long(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            moveMail_N1213845183626713609 moveMail_N12138451836267136092 = new moveMail_N1213845183626713609(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            moveMail_N12138451836267136092.arguments = this.arguments;
            ((InvocationBase)moveMail_N12138451836267136092).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)moveMail_N12138451836267136092).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)moveMail_N12138451836267136092).instanceResolver = ((InvocationBase)this).instanceResolver;
            moveMail_N12138451836267136092.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)moveMail_N12138451836267136092).targetObject = ((InvocationBase)this).targetObject;
            moveMail_N12138451836267136092.arg0 = this.arg0;
            moveMail_N12138451836267136092.arg1 = this.arg1;
            moveMail_N12138451836267136092.arg2 = this.arg2;
            return moveMail_N12138451836267136092;
        }
    }
}

