/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.s3;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.store.s3.S3FileStoreService;
import org.buni.s3filestore.S3FileStore;
import org.buni.s3filestore.S3InputStream;
import org.buni.s3filestore.ejb.S3StoreIdGeneratorDAO;
import org.buni.s3filestore.ejb.S3StoreIdGeneratorDAOImpl;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3FileStoreServiceImpl
extends AbstractStore
implements S3FileStoreService,
Advised {
    S3FileStore s3FileStore;
    private String defaultS3Host = "s3.amazonws.com";
    private boolean useSSL = new Boolean(true);
    private String awsSystemAccessKey;
    private String awsSystemSecretAccessKey;
    private String defaultBucket = "";
    private String defaultPath = "meldware/messages";
    private int numRetries = 3;
    private int retrySleep = 2000;
    private long maxS3FileSize = 0x140000000L;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.s3.S3FileStoreServiceImpl"));
    private static WeakReference aop$MethodInfo_getBuffer_N_8328802641894955898;

    @Override
    public void init() {
        Properties props = new Properties();
        props.put("defaultS3Host", this.defaultS3Host);
        props.put("useSSL", (Object)this.useSSL);
        props.put("awsSystemAccessKey", this.awsSystemAccessKey);
        props.put("awsSystemSecretAccessKey", this.awsSystemSecretAccessKey);
        props.put("defaultBucket", this.defaultBucket);
        props.put("defaultPath", this.defaultPath);
        props.put("maxS3FileSize", (Object)this.maxS3FileSize);
        props.put("numRetries", (Object)this.numRetries);
        props.put("retrySleep", (Object)this.retrySleep);
        this.s3FileStore = new S3FileStore(props);
    }

    @Override
    protected Long doCreate() throws StoreException {
        try {
            Properties properties = new Properties();
            InitialContext ctx = new InitialContext(properties);
            String sJNDIName = "mail/" + S3StoreIdGeneratorDAOImpl.class.getSimpleName() + "/local";
            S3StoreIdGeneratorDAO keygen = (S3StoreIdGeneratorDAO)ctx.lookup(sJNDIName);
            return keygen.getNextId();
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public void cleanUp(List<Long> bods) {
        int i = 0;
        while (i < bods.size()) {
            this.delete(bods.get(i));
            ++i;
        }
    }

    @Override
    public void delete(Long id) throws StoreException {
        this.s3FileStore.delete(id.longValue());
    }

    @Tx(value=TxType.REQUIRED)
    public ByteBuffer org$buni$meldware$mail$store$s3$S3FileStoreServiceImpl$getBuffer$aop(Long id, long position, int len) throws StoreException {
        ByteBuffer buffer;
        try {
            S3InputStream iStream = this.s3FileStore.getInputStream(id.longValue(), position, len);
            byte[] b = new byte[len];
            int numRead = iStream.read(b, 0, len);
            buffer = ByteBuffer.wrap(b, 0, numRead);
            iStream.close();
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
        return buffer;
    }

    @Override
    public InputStream getInputStream(Long id, StoreItemMetaData meta) throws StoreException {
        try {
            return this.s3FileStore.getInputStream(id.longValue(), null);
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(Long id, StoreItemMetaData meta) throws StoreException {
        try {
            return this.s3FileStore.getOutputStream(id.longValue(), null);
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    public String idToString(Object id) {
        return id.toString();
    }

    @Override
    public int read(Long id, long position, byte[] b, int off, int len) throws StoreException {
        int read = 0;
        try {
            S3InputStream iStream = this.s3FileStore.getInputStream(id.longValue(), position, -1, null);
            read = iStream.read(b, off, len);
            iStream.close();
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
        return read;
    }

    public Object stringToId(String s) {
        return Long.parseLong(s);
    }

    @Override
    public int write(Long id, long position, byte[] b, int off, int len) throws StoreException {
        throw new StoreException("Amazon S3 does not allow partial writes.  Please use 'getOutputStream(..) instead.");
    }

    @Override
    public String getAwsSystemAccessKey() {
        return this.awsSystemAccessKey;
    }

    @Override
    public void setAwsSystemAccessKey(String awsSystemAccessKey) {
        this.awsSystemAccessKey = awsSystemAccessKey;
    }

    @Override
    public String getAwsSystemSecretAccessKey() {
        return this.awsSystemSecretAccessKey;
    }

    @Override
    public void setAwsSystemSecretAccessKey(String awsSystemSecretAccessKey) {
        this.awsSystemSecretAccessKey = awsSystemSecretAccessKey;
    }

    @Override
    public String getDefaultBucket() {
        return this.defaultBucket;
    }

    @Override
    public void setDefaultBucket(String defaultBucket) {
        this.defaultBucket = defaultBucket;
    }

    @Override
    public String getDefaultPath() {
        return this.defaultPath;
    }

    @Override
    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    @Override
    public String getDefaultS3Host() {
        return this.defaultS3Host;
    }

    @Override
    public void setDefaultS3Host(String defaultS3Host) {
        this.defaultS3Host = defaultS3Host;
    }

    @Override
    public long getMaxS3FileSize() {
        return this.maxS3FileSize;
    }

    @Override
    public void setMaxS3FileSize(long maxS3FileSize) {
        this.maxS3FileSize = maxS3FileSize;
    }

    @Override
    public int getNumRetries() {
        return this.numRetries;
    }

    @Override
    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    @Override
    public int getRetrySleep() {
        return this.retrySleep;
    }

    @Override
    public void setRetrySleep(int retrySleep) {
        this.retrySleep = retrySleep;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public ByteBuffer getBuffer(Long l, long l2, int n) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBuffer_N_8328802641894955898.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(methodInfo, interceptorArray);
            getBuffer_N83288026418949558982.arg0 = l;
            getBuffer_N83288026418949558982.arg1 = l2;
            getBuffer_N83288026418949558982.arg2 = n;
            getBuffer_N83288026418949558982.setTargetObject(this);
            getBuffer_N83288026418949558982.typedTargetObject = this;
            getBuffer_N83288026418949558982.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (ByteBuffer)getBuffer_N83288026418949558982.invokeNext();
        }
        return this.org$buni$meldware$mail$store$s3$S3FileStoreServiceImpl$getBuffer$aop(l, l2, n);
    }

    public static class getBuffer_N8328802641894955898
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public int arg2;
        public S3FileStoreServiceImpl typedTargetObject;

        public getBuffer_N8328802641894955898(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBuffer_N8328802641894955898() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$s3$S3FileStoreServiceImpl$getBuffer$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBuffer_N83288026418949558982.arguments = this.arguments;
            ((InvocationBase)getBuffer_N83288026418949558982).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBuffer_N83288026418949558982).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBuffer_N83288026418949558982).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBuffer_N83288026418949558982.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBuffer_N83288026418949558982).targetObject = ((InvocationBase)this).targetObject;
            getBuffer_N83288026418949558982.arg0 = this.arg0;
            getBuffer_N83288026418949558982.arg1 = this.arg1;
            getBuffer_N83288026418949558982.arg2 = this.arg2;
            return getBuffer_N83288026418949558982;
        }
    }
}

