/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.management.ObjectName;
import javax.persistence.Query;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.BlobInputStream;
import org.buni.meldware.mail.store.BlobOutputStream;
import org.buni.meldware.mail.store.StoreClerk;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.store.StoreItemNotFoundException;
import org.buni.meldware.mail.store.jdbc3.Item;
import org.buni.meldware.mail.store.jdbc3.JDBC3StoreMBean;
import org.buni.meldware.mail.util.DbUtil;
import org.buni.meldware.mail.util.io.WrappedInputStream;
import org.buni.meldware.mail.util.io.WrappedOutputStream;
import org.hibernate.lob.BlobImpl;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.jboss.ejb3.entity.HibernateSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBC3Store
extends AbstractStore
implements JDBC3StoreMBean,
Advised {
    public static final String TRUE = "T";
    public static final String FALSE = "F";
    private static Log log;
    private String readStatement = null;
    private String writeStatement = null;
    private String idColumn = null;
    private String blobColumn = null;
    private String tableName = null;
    private boolean useStreams = true;
    private boolean connected = false;
    private static ClassAdvisor aop$classAdvisor$aop;
    private static WeakReference aop$MethodInfo_getSize_N_4001279970839596687;
    private static WeakReference aop$MethodInfo_read_N_150580156191630418;
    private static WeakReference aop$MethodInfo_getBuffer_N_8328802641894955898;
    private static WeakReference aop$MethodInfo_write_N_7611023959546435916;
    private static WeakReference aop$MethodInfo_getWrappedInputStream_N_1882668560353339066;
    private static WeakReference aop$MethodInfo_getWrappedOutputStream_N_4280415840697886448;
    private static WeakReference aop$MethodInfo_doCreate3781003712992460599;
    private static WeakReference aop$MethodInfo_delete_N_169551518371285982;

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.jdbc3.JDBC3Store"));
        log = Log.getLog(JDBC3Store.class);
    }

    @Override
    public String getBlobColumn() {
        return this.blobColumn;
    }

    @Override
    public void setBlobColumn(String blobColumn) {
        this.blobColumn = blobColumn;
    }

    @Override
    public String getIdColumn() {
        return this.idColumn;
    }

    @Override
    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    @Override
    public String getReadStatement() {
        return this.readStatement;
    }

    @Override
    public void setReadStatement(String selectStatement) {
        this.readStatement = selectStatement;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public boolean getUseStreams() {
        return this.useStreams;
    }

    @Override
    public void setUseStreams(boolean useStreams) {
        this.useStreams = useStreams;
    }

    @Override
    public boolean getConnected() {
        return this.connected;
    }

    @Override
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public String getWriteStatement() {
        return this.writeStatement;
    }

    @Override
    public void setWriteStatement(String writeStatement) {
        this.writeStatement = writeStatement;
    }

    public String idToString(Object id) {
        return (String)id;
    }

    public Object stringToId(String s) {
        return s;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public long org$buni$meldware$mail$store$jdbc3$JDBC3Store$getSize$aop(Long id) throws StoreException {
        long size;
        PreparedStatement psGet = null;
        ResultSet rs = null;
        log.debug((Object)("Getting size for oid: " + id));
        try {
            try {
                psGet = ((HibernateSession)this.session).getHibernateSession().connection().prepareStatement(this.getReadStatement());
                psGet.setObject(1, id);
                rs = psGet.executeQuery();
                if (!rs.next()) {
                    throw new StoreItemNotFoundException((Object)("Stream with id: " + id + " does not exist"));
                }
                Blob blob = rs.getBlob(this.blobColumn);
                size = blob.length();
            }
            catch (SQLException e) {
                log.error((Object)("Get size failed for id: " + id + ": " + e.getMessage()));
                throw new StoreException("Get size failed for id: " + id, e);
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeQuietly(log, rs);
            DbUtil.closeQuietly(log, psGet);
            throw throwable;
        }
        DbUtil.closeQuietly(log, rs);
        DbUtil.closeQuietly(log, psGet);
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Tx(value=TxType.REQUIRESNEW)
    public int org$buni$meldware$mail$store$jdbc3$JDBC3Store$read$aop(Long id, long position, byte[] b, int off, int len) throws StoreException {
        int bytesRead;
        long length;
        Blob blob;
        ResultSet rs;
        PreparedStatement psGet;
        block9: {
            psGet = null;
            rs = null;
            log.debug((Object)("Read oid: " + id + ", position: " + position + ", length: " + len));
            psGet = ((HibernateSession)this.session).getHibernateSession().connection().prepareStatement(this.getReadStatement());
            psGet.setObject(1, id);
            rs = psGet.executeQuery();
            if (!rs.next()) throw new StoreItemNotFoundException((Object)("Stream with id: " + id + " does not exist"));
            blob = rs.getBlob(this.blobColumn);
            length = blob.length();
            if (length >= position) break block9;
            DbUtil.closeQuietly(log, rs);
            DbUtil.closeQuietly(log, psGet);
            return 0;
        }
        try {
            try {
                if (this.useStreams) {
                    InputStream in = blob.getBinaryStream();
                    in.skip(position - (long)StoreClerk.longToInt(this.getStartIndex()));
                    bytesRead = in.read(b, off, len);
                } else {
                    bytesRead = 0;
                    while (len > bytesRead && position <= length) {
                        int toPut = Math.min(len - bytesRead, this.getPageSize());
                        byte[] inBytes = blob.getBytes(position, toPut);
                        int numBytes = inBytes.length;
                        System.arraycopy(inBytes, 0, b, off + bytesRead, numBytes);
                        bytesRead += numBytes;
                        position += (long)numBytes;
                    }
                }
            }
            catch (IOException e) {
                throw new StoreException("Read oid: " + id + ", position: " + position + ", length: " + len, e);
            }
            catch (SQLException e) {
                throw new StoreException("Read oid: " + id + ", position: " + position + ", length: " + len, e);
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeQuietly(log, rs);
            DbUtil.closeQuietly(log, psGet);
            throw throwable;
        }
        DbUtil.closeQuietly(log, rs);
        DbUtil.closeQuietly(log, psGet);
        return bytesRead;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public ByteBuffer org$buni$meldware$mail$store$jdbc3$JDBC3Store$getBuffer$aop(Long id, long position, int len) throws StoreException {
        ByteBuffer buffer;
        ResultSet rs;
        PreparedStatement psGet;
        block9: {
            psGet = null;
            rs = null;
            log.debug((Object)("Get Buffer oid: " + id + ", position: " + position + ", length: " + len));
            try {
                try {
                    psGet = ((HibernateSession)this.session).getHibernateSession().connection().prepareStatement(this.getReadStatement());
                    psGet.setObject(1, id);
                    rs = psGet.executeQuery();
                    if (rs.next()) {
                        Blob blob = rs.getBlob(this.blobColumn);
                        long length = blob.length();
                        if (len > this.getPageSize()) {
                            throw new StoreException("Requested length: " + len + " exceeds the maxBlockSize: " + this.getPageSize());
                        }
                        if (this.useStreams) {
                            InputStream in = blob.getBinaryStream();
                            in.skip(position - 1L);
                            int remaining = StoreClerk.longToInt(length - position);
                            byte[] b = new byte[Math.min(remaining + 1, len)];
                            int numRead = in.read(b);
                            buffer = ByteBuffer.wrap(b, 0, numRead);
                        } else {
                            byte[] b = blob.getBytes(position, len);
                            buffer = b != null ? ByteBuffer.wrap(b) : ByteBuffer.allocate(0);
                        }
                        break block9;
                    }
                    throw new StoreItemNotFoundException((Object)("Stream with id: " + id + " does not exist"));
                }
                catch (IOException e) {
                    throw new StoreException("Get Buffer oid: " + id + ", position: " + position + ", length: " + len, e);
                }
                catch (SQLException e) {
                    throw new StoreException("Get Buffer oid: " + id + ", position: " + position + ", length: " + len, e);
                }
            }
            catch (Throwable throwable) {
                DbUtil.closeQuietly(log, rs);
                DbUtil.closeQuietly(log, psGet);
                throw throwable;
            }
        }
        DbUtil.closeQuietly(log, rs);
        DbUtil.closeQuietly(log, psGet);
        return buffer;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public int org$buni$meldware$mail$store$jdbc3$JDBC3Store$write$aop(Long id, long position, byte[] b, int off, int len) throws StoreException {
        int bytesWritten;
        ResultSet rs;
        PreparedStatement psGet;
        block9: {
            psGet = null;
            rs = null;
            log.debug((Object)("Write oid: " + id + ", position: " + position + ", length: " + len));
            try {
                try {
                    psGet = ((HibernateSession)this.session).getHibernateSession().connection().prepareStatement(this.getWriteStatement());
                    psGet.setObject(1, id);
                    rs = psGet.executeQuery();
                    if (rs.next()) {
                        Blob blob = rs.getBlob(this.blobColumn);
                        if (this.useStreams) {
                            OutputStream out = blob.setBinaryStream(position);
                            out.write(b, off, len);
                            bytesWritten = len;
                        } else {
                            bytesWritten = 0;
                            while (len > bytesWritten) {
                                int toGet = Math.min(len - bytesWritten, this.getPageSize());
                                blob.setBytes(position, b, off + bytesWritten, toGet);
                                bytesWritten += toGet;
                                position += (long)toGet;
                            }
                        }
                        break block9;
                    }
                    throw new StoreItemNotFoundException((Object)("Stream with id: " + id + " does not exist"));
                }
                catch (IOException e) {
                    throw new StoreException("Write oid: " + id + ", position: " + position + ", length: " + len + ", reason: " + e.getMessage(), e);
                }
                catch (SQLException e) {
                    throw new StoreException("Write oid: " + id + ", position: " + position + ", length: " + len + ", reason: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                DbUtil.closeQuietly(log, rs);
                DbUtil.closeQuietly(log, psGet);
                throw throwable;
            }
        }
        DbUtil.closeQuietly(log, rs);
        DbUtil.closeQuietly(log, psGet);
        return bytesWritten;
    }

    @Override
    public InputStream getInputStream(Long id, StoreItemMetaData meta) throws StoreException {
        InputStream in = this.connected ? this.getWrappedInputStream(id) : new BlobInputStream(this, meta);
        return in;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public InputStream org$buni$meldware$mail$store$jdbc3$JDBC3Store$getWrappedInputStream$aop(Long id) throws StoreException {
        WrappedInputStream in;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = ((HibernateSession)this.session).getHibernateSession().connection().prepareStatement(this.getReadStatement());
            ps.setObject(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new StoreItemNotFoundException((Object)("Stream with id: " + id + " does not exist"));
            }
            Blob b = rs.getBlob(this.getBlobColumn());
            in = new WrappedInputStream(b.getBinaryStream());
        }
        catch (SQLException e) {
            throw new StoreException("Failed to get wrapped input stream for StoreItem: " + id, e);
        }
        return in;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public OutputStream org$buni$meldware$mail$store$jdbc3$JDBC3Store$getWrappedOutputStream$aop(Long id) throws StoreException {
        WrappedOutputStream out;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = ((HibernateSession)this.session).getHibernateSession().connection().prepareStatement(this.getReadStatement());
            ps.setObject(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new StoreItemNotFoundException((Object)("Stream with id: " + id + " does not exist"));
            }
            Blob b = rs.getBlob(this.getBlobColumn());
            out = new WrappedOutputStream(b.setBinaryStream(this.getStartIndex()));
        }
        catch (SQLException e) {
            throw new StoreException("Failed to get wrapped output stream for StoreItem: " + id, e);
        }
        return out;
    }

    @Override
    public OutputStream getOutputStream(Long id, StoreItemMetaData meta) throws StoreException {
        OutputStream out = this.getConnected() ? this.getWrappedOutputStream(id) : new BlobOutputStream(this, meta);
        return out;
    }

    @Tx(value=TxType.REQUIRESNEW)
    protected Long org$buni$meldware$mail$store$jdbc3$JDBC3Store$doCreate$aop() throws StoreException {
        log.debug((Object)"Creating new store item");
        Item item = new Item();
        item.setData((Blob)new BlobImpl(new byte[]{120}));
        this.session.persist(item);
        return item.getId();
    }

    @Tx(value=TxType.REQUIRESNEW)
    public void org$buni$meldware$mail$store$jdbc3$JDBC3Store$delete$aop(Long id) throws StoreException {
        Query q = this.session.createQuery("delete org.buni.meldware.mail.store.jdbc3.Item where id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
    }

    @Override
    public void validate() throws StoreException {
        super.validate();
        this.testNull("ReadStatement", this.getReadStatement());
        this.testNull("WriteStatement", this.getWriteStatement());
    }

    @Override
    public void init() throws StoreException {
        log.info((Object)"Initalising JDBC3 Store");
    }

    @Override
    public ObjectName getServiceName() {
        return null;
    }

    @Override
    public void cleanUp(List<Long> bods) {
        String bodsStr = ArrayUtil.longListCommaDel(bods);
        String hql = "delete from org.buni.meldware.mail.store.jdbc3.Item where id in (" + bodsStr + ")";
        this.session.createQuery(hql).executeUpdate();
        hql = "delete from org.buni.meldware.mail.store.StoreItemMetaData s where s.pid in (" + bodsStr + ")";
        this.session.createQuery(hql).executeUpdate();
    }

    @Override
    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public long getSize(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getSize_N_4001279970839596687.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getSize_N4001279970839596687 getSize_N40012799708395966872 = new getSize_N4001279970839596687(methodInfo, interceptorArray);
            getSize_N40012799708395966872.arg0 = l;
            getSize_N40012799708395966872.setTargetObject(this);
            getSize_N40012799708395966872.typedTargetObject = this;
            getSize_N40012799708395966872.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)getSize_N40012799708395966872.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getSize$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public int read(Long l, long l2, byte[] byArray, int n, int n2) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_read_N_150580156191630418.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            read_N150580156191630418 read_N1505801561916304182 = new read_N150580156191630418(methodInfo, interceptorArray);
            read_N1505801561916304182.arg0 = l;
            read_N1505801561916304182.arg1 = l2;
            read_N1505801561916304182.arg2 = byArray;
            read_N1505801561916304182.arg3 = n;
            read_N1505801561916304182.arg4 = n2;
            read_N1505801561916304182.setTargetObject(this);
            read_N1505801561916304182.typedTargetObject = this;
            read_N1505801561916304182.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)read_N1505801561916304182.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$read$aop(l, l2, byArray, n, n2);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public ByteBuffer getBuffer(Long l, long l2, int n) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBuffer_N_8328802641894955898.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(methodInfo, interceptorArray);
            getBuffer_N83288026418949558982.arg0 = l;
            getBuffer_N83288026418949558982.arg1 = l2;
            getBuffer_N83288026418949558982.arg2 = n;
            getBuffer_N83288026418949558982.setTargetObject(this);
            getBuffer_N83288026418949558982.typedTargetObject = this;
            getBuffer_N83288026418949558982.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (ByteBuffer)getBuffer_N83288026418949558982.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getBuffer$aop(l, l2, n);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public int write(Long l, long l2, byte[] byArray, int n, int n2) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_write_N_7611023959546435916.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            write_N7611023959546435916 write_N76110239595464359162 = new write_N7611023959546435916(methodInfo, interceptorArray);
            write_N76110239595464359162.arg0 = l;
            write_N76110239595464359162.arg1 = l2;
            write_N76110239595464359162.arg2 = byArray;
            write_N76110239595464359162.arg3 = n;
            write_N76110239595464359162.arg4 = n2;
            write_N76110239595464359162.setTargetObject(this);
            write_N76110239595464359162.typedTargetObject = this;
            write_N76110239595464359162.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)write_N76110239595464359162.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$write$aop(l, l2, byArray, n, n2);
    }

    @Tx(value=TxType.REQUIRESNEW)
    public InputStream getWrappedInputStream(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getWrappedInputStream_N_1882668560353339066.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getWrappedInputStream_N1882668560353339066 getWrappedInputStream_N18826685603533390662 = new getWrappedInputStream_N1882668560353339066(methodInfo, interceptorArray);
            getWrappedInputStream_N18826685603533390662.arg0 = l;
            getWrappedInputStream_N18826685603533390662.setTargetObject(this);
            getWrappedInputStream_N18826685603533390662.typedTargetObject = this;
            getWrappedInputStream_N18826685603533390662.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InputStream)getWrappedInputStream_N18826685603533390662.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getWrappedInputStream$aop(l);
    }

    @Tx(value=TxType.REQUIRESNEW)
    public OutputStream getWrappedOutputStream(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getWrappedOutputStream_N_4280415840697886448.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getWrappedOutputStream_N4280415840697886448 getWrappedOutputStream_N42804158406978864482 = new getWrappedOutputStream_N4280415840697886448(methodInfo, interceptorArray);
            getWrappedOutputStream_N42804158406978864482.arg0 = l;
            getWrappedOutputStream_N42804158406978864482.setTargetObject(this);
            getWrappedOutputStream_N42804158406978864482.typedTargetObject = this;
            getWrappedOutputStream_N42804158406978864482.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (OutputStream)getWrappedOutputStream_N42804158406978864482.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getWrappedOutputStream$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    protected Long doCreate() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_doCreate3781003712992460599.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            doCreate_3781003712992460599 doCreate_37810037129924605992 = new doCreate_3781003712992460599(methodInfo, interceptorArray);
            doCreate_37810037129924605992.setTargetObject(this);
            doCreate_37810037129924605992.typedTargetObject = this;
            doCreate_37810037129924605992.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)doCreate_37810037129924605992.invokeNext();
        }
        return this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$doCreate$aop();
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public void delete(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_delete_N_169551518371285982.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            delete_N169551518371285982 delete_N1695515183712859822 = new delete_N169551518371285982(methodInfo, interceptorArray);
            delete_N1695515183712859822.arg0 = l;
            delete_N1695515183712859822.setTargetObject(this);
            delete_N1695515183712859822.typedTargetObject = this;
            delete_N1695515183712859822.setAdvisor((Advisor)aop$classAdvisor$aop);
            delete_N1695515183712859822.invokeNext();
        } else {
            this.org$buni$meldware$mail$store$jdbc3$JDBC3Store$delete$aop(l);
        }
    }

    public static class getSize_N4001279970839596687
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public JDBC3Store typedTargetObject;

        public getSize_N4001279970839596687(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getSize_N4001279970839596687(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getSize_N4001279970839596687(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getSize_N4001279970839596687() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Long(this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getSize$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getSize_N4001279970839596687 getSize_N40012799708395966872 = new getSize_N4001279970839596687(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getSize_N40012799708395966872.arguments = this.arguments;
            ((InvocationBase)getSize_N40012799708395966872).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getSize_N40012799708395966872).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getSize_N40012799708395966872).instanceResolver = ((InvocationBase)this).instanceResolver;
            getSize_N40012799708395966872.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getSize_N40012799708395966872).targetObject = ((InvocationBase)this).targetObject;
            getSize_N40012799708395966872.arg0 = this.arg0;
            return getSize_N40012799708395966872;
        }
    }

    public static class read_N150580156191630418
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public byte[] arg2;
        public int arg3;
        public int arg4;
        public JDBC3Store typedTargetObject;

        public read_N150580156191630418(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public read_N150580156191630418(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public read_N150580156191630418(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public read_N150580156191630418() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$read$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            Object object2 = objectArray[2];
            this.arg2 = (byte[])object2;
            this.arg3 = (Integer)objectArray[3];
            this.arg4 = (Integer)objectArray[4];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[5];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            this.arguments[2] = this.arg2;
            new Integer(this.arg3);
            new Integer(this.arg4);
            return this.arguments;
        }

        public Invocation copy() {
            read_N150580156191630418 read_N1505801561916304182 = new read_N150580156191630418(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            read_N1505801561916304182.arguments = this.arguments;
            ((InvocationBase)read_N1505801561916304182).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)read_N1505801561916304182).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)read_N1505801561916304182).instanceResolver = ((InvocationBase)this).instanceResolver;
            read_N1505801561916304182.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)read_N1505801561916304182).targetObject = ((InvocationBase)this).targetObject;
            read_N1505801561916304182.arg0 = this.arg0;
            read_N1505801561916304182.arg1 = this.arg1;
            read_N1505801561916304182.arg2 = this.arg2;
            read_N1505801561916304182.arg3 = this.arg3;
            read_N1505801561916304182.arg4 = this.arg4;
            return read_N1505801561916304182;
        }
    }

    public static class getBuffer_N8328802641894955898
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public int arg2;
        public JDBC3Store typedTargetObject;

        public getBuffer_N8328802641894955898(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBuffer_N8328802641894955898() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getBuffer$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBuffer_N83288026418949558982.arguments = this.arguments;
            ((InvocationBase)getBuffer_N83288026418949558982).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBuffer_N83288026418949558982).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBuffer_N83288026418949558982).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBuffer_N83288026418949558982.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBuffer_N83288026418949558982).targetObject = ((InvocationBase)this).targetObject;
            getBuffer_N83288026418949558982.arg0 = this.arg0;
            getBuffer_N83288026418949558982.arg1 = this.arg1;
            getBuffer_N83288026418949558982.arg2 = this.arg2;
            return getBuffer_N83288026418949558982;
        }
    }

    public static class write_N7611023959546435916
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public byte[] arg2;
        public int arg3;
        public int arg4;
        public JDBC3Store typedTargetObject;

        public write_N7611023959546435916(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public write_N7611023959546435916(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public write_N7611023959546435916(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public write_N7611023959546435916() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$write$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            Object object2 = objectArray[2];
            this.arg2 = (byte[])object2;
            this.arg3 = (Integer)objectArray[3];
            this.arg4 = (Integer)objectArray[4];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[5];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            this.arguments[2] = this.arg2;
            new Integer(this.arg3);
            new Integer(this.arg4);
            return this.arguments;
        }

        public Invocation copy() {
            write_N7611023959546435916 write_N76110239595464359162 = new write_N7611023959546435916(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            write_N76110239595464359162.arguments = this.arguments;
            ((InvocationBase)write_N76110239595464359162).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)write_N76110239595464359162).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)write_N76110239595464359162).instanceResolver = ((InvocationBase)this).instanceResolver;
            write_N76110239595464359162.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)write_N76110239595464359162).targetObject = ((InvocationBase)this).targetObject;
            write_N76110239595464359162.arg0 = this.arg0;
            write_N76110239595464359162.arg1 = this.arg1;
            write_N76110239595464359162.arg2 = this.arg2;
            write_N76110239595464359162.arg3 = this.arg3;
            write_N76110239595464359162.arg4 = this.arg4;
            return write_N76110239595464359162;
        }
    }

    public static class getWrappedInputStream_N1882668560353339066
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public JDBC3Store typedTargetObject;

        public getWrappedInputStream_N1882668560353339066(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getWrappedInputStream_N1882668560353339066(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getWrappedInputStream_N1882668560353339066(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getWrappedInputStream_N1882668560353339066() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getWrappedInputStream$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getWrappedInputStream_N1882668560353339066 getWrappedInputStream_N18826685603533390662 = new getWrappedInputStream_N1882668560353339066(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getWrappedInputStream_N18826685603533390662.arguments = this.arguments;
            ((InvocationBase)getWrappedInputStream_N18826685603533390662).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getWrappedInputStream_N18826685603533390662).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getWrappedInputStream_N18826685603533390662).instanceResolver = ((InvocationBase)this).instanceResolver;
            getWrappedInputStream_N18826685603533390662.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getWrappedInputStream_N18826685603533390662).targetObject = ((InvocationBase)this).targetObject;
            getWrappedInputStream_N18826685603533390662.arg0 = this.arg0;
            return getWrappedInputStream_N18826685603533390662;
        }
    }

    public static class getWrappedOutputStream_N4280415840697886448
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public JDBC3Store typedTargetObject;

        public getWrappedOutputStream_N4280415840697886448(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getWrappedOutputStream_N4280415840697886448(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getWrappedOutputStream_N4280415840697886448(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getWrappedOutputStream_N4280415840697886448() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$getWrappedOutputStream$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getWrappedOutputStream_N4280415840697886448 getWrappedOutputStream_N42804158406978864482 = new getWrappedOutputStream_N4280415840697886448(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getWrappedOutputStream_N42804158406978864482.arguments = this.arguments;
            ((InvocationBase)getWrappedOutputStream_N42804158406978864482).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getWrappedOutputStream_N42804158406978864482).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getWrappedOutputStream_N42804158406978864482).instanceResolver = ((InvocationBase)this).instanceResolver;
            getWrappedOutputStream_N42804158406978864482.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getWrappedOutputStream_N42804158406978864482).targetObject = ((InvocationBase)this).targetObject;
            getWrappedOutputStream_N42804158406978864482.arg0 = this.arg0;
            return getWrappedOutputStream_N42804158406978864482;
        }
    }

    public static class doCreate_3781003712992460599
    extends MethodInvocation
    implements Untransformable {
        public JDBC3Store typedTargetObject;

        public doCreate_3781003712992460599(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public doCreate_3781003712992460599(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public doCreate_3781003712992460599(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public doCreate_3781003712992460599() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$doCreate$aop();
        }

        public Invocation copy() {
            doCreate_3781003712992460599 doCreate_37810037129924605992 = new doCreate_3781003712992460599(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            doCreate_37810037129924605992.arguments = this.arguments;
            ((InvocationBase)doCreate_37810037129924605992).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)doCreate_37810037129924605992).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)doCreate_37810037129924605992).instanceResolver = ((InvocationBase)this).instanceResolver;
            doCreate_37810037129924605992.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)doCreate_37810037129924605992).targetObject = ((InvocationBase)this).targetObject;
            return doCreate_37810037129924605992;
        }
    }

    public static class delete_N169551518371285982
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public JDBC3Store typedTargetObject;

        public delete_N169551518371285982(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public delete_N169551518371285982(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public delete_N169551518371285982(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public delete_N169551518371285982() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$store$jdbc3$JDBC3Store$delete$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            delete_N169551518371285982 delete_N1695515183712859822 = new delete_N169551518371285982(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            delete_N1695515183712859822.arguments = this.arguments;
            ((InvocationBase)delete_N1695515183712859822).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)delete_N1695515183712859822).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)delete_N1695515183712859822).instanceResolver = ((InvocationBase)this).instanceResolver;
            delete_N1695515183712859822.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)delete_N1695515183712859822).targetObject = ((InvocationBase)this).targetObject;
            delete_N1695515183712859822.arg0 = this.arg0;
            return delete_N1695515183712859822;
        }
    }
}

