/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store;

import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.buni.meldware.mail.store.StoreException;

public class StoreTransaction {
    final UserTransaction ut;
    static final Log log = LogFactory.getLog(StoreTransaction.class);
    boolean isNewTx = false;
    boolean isRolledback = false;

    public StoreTransaction(UserTransaction ut) {
        this.ut = ut;
    }

    public void begin() throws StoreException {
        try {
            if (this.ut.getStatus() != 0) {
                this.ut.begin();
                log.debug("Begun Transaction");
                this.isNewTx = true;
            } else {
                log.debug("Transaction already active" + this.ut.getStatus());
            }
        }
        catch (Exception e) {
            log.error("Failed to begin transaction: " + e.getMessage());
            throw new StoreException("Unable to begin transaction: " + e.getMessage(), e);
        }
    }

    public void commit() throws StoreException {
        try {
            if (!this.isNewTx) {
                log.debug("Not committing existing transaction");
            } else if (this.ut.getStatus() == 0) {
                this.ut.commit();
                log.debug("Committed Transaction");
            } else {
                log.debug("Status: " + this.ut.getStatus() + " is not active, not committing");
            }
        }
        catch (Exception e) {
            log.error("Failed to commit transaction: " + e.getMessage());
            throw new StoreException(e);
        }
    }

    public void rollback() throws StoreException {
        try {
            if (!this.isNewTx) {
                log.debug("Not committing existing transaction");
            } else if (this.ut.getStatus() == 0) {
                this.ut.rollback();
                this.isRolledback = true;
                log.debug("Rolled back Transaction");
            } else {
                log.debug("Status: " + this.ut.getStatus() + " is not active, not rolling back");
            }
        }
        catch (Exception e) {
            log.error("Failed to rollback transaction: " + e.getMessage());
            throw new StoreException(e);
        }
    }

    public boolean isRolledback() {
        return this.isRolledback;
    }
}

