/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItem;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.util.io.CountingOutputStream;
import org.buni.meldware.mail.util.io.HashingOutputStream;
import org.buni.meldware.mail.util.io.IOUtil;
import org.buni.meldware.mail.util.io.StreamCloseEvent;
import org.buni.meldware.mail.util.io.StreamCloseListener;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

public class StoreItemImpl
implements StoreItem,
StreamCloseListener,
Advised {
    private static final Log log;
    private Long id;
    private AbstractStore store;
    private StoreItemMetaData metaData;
    private CountingOutputStream cOut;
    private HashingOutputStream hOut;
    private static ClassAdvisor aop$classAdvisor$aop;
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getInputStream_N_6796966186260264682;
    private static WeakReference aop$MethodInfo_getOuputStream4369506288762056207;
    private static WeakReference aop$MethodInfo_getMetaData8332461243561844888;
    private static WeakReference aop$MethodInfo_streamClosed7890526911085883131;

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.StoreItemImpl"));
        log = Log.getLog(StoreItemImpl.class);
    }

    public StoreItemImpl(Long id, AbstractStore store) {
        this.id = id;
        this.store = store;
    }

    public Long getId() {
        return this.id;
    }

    @Tx(value=TxType.REQUIRED)
    public InputStream org$buni$meldware$mail$store$StoreItemImpl$getInputStream$aop() throws StoreException {
        InputStream in = this.store.getInputStream(this.id, this.getMetaData());
        if (this.getMetaData().getCompressed()) {
            in = new InflaterInputStream(in, new Inflater(), this.getMetaData().getPageSize());
        }
        return in;
    }

    @Tx(value=TxType.REQUIRED)
    public OutputStream org$buni$meldware$mail$store$StoreItemImpl$getOuputStream$aop() throws StoreException {
        OutputStream out = null;
        try {
            out = this.store.getOutputStream(this.id, this.getMetaData());
            if (this.getMetaData().getCompressed()) {
                out = new DeflaterOutputStream(out, new Deflater(), this.getMetaData().getPageSize());
            }
            if (this.getMetaData().getHashed()) {
                this.hOut = new HashingOutputStream("SHA-256", out);
                this.cOut = new CountingOutputStream(this.hOut);
            } else {
                this.cOut = new CountingOutputStream(out);
            }
            this.cOut.addListener(this);
            return this.cOut;
        }
        catch (NoSuchAlgorithmException e) {
            IOUtil.quietClose(log, out);
            throw new StoreException(e);
        }
    }

    public void delete() throws StoreException {
        this.store.delete(this.id);
    }

    public int getSize() throws StoreException {
        return (int)this.getMetaData().getItemSize();
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItemMetaData org$buni$meldware$mail$store$StoreItemImpl$getMetaData$aop() throws StoreException {
        if (this.metaData == null) {
            this.setMetaData(this.store.loadMetaData(this.id));
        }
        return this.metaData;
    }

    public void setMetaData(StoreItemMetaData metaData) {
        this.metaData = metaData;
    }

    public AbstractStore getStore() {
        return this.store;
    }

    public void close() throws StoreException {
        StoreItemMetaData md = this.getMetaData();
        md.setItemSize(Math.max(this.cOut.getCounter(), md.getItemSize()));
        if (md.getHashed()) {
            md.setHash(this.hOut.getHash());
        }
        this.getStore().updateMetaData(md);
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$store$StoreItemImpl$streamClosed$aop(StreamCloseEvent event) throws IOException {
        try {
            this.close();
        }
        catch (StoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public long getStartIndex() {
        return this.getMetaData().getStartIndex();
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        StoreItemImpl storeItemImpl = this;
        synchronized (storeItemImpl) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        StoreItemImpl storeItemImpl = this;
        synchronized (storeItemImpl) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public InputStream getInputStream() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getInputStream_N_6796966186260264682.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getInputStream_N6796966186260264682 getInputStream_N67969661862602646822 = new getInputStream_N6796966186260264682(methodInfo, interceptorArray);
            getInputStream_N67969661862602646822.setTargetObject(this);
            getInputStream_N67969661862602646822.typedTargetObject = this;
            getInputStream_N67969661862602646822.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InputStream)getInputStream_N67969661862602646822.invokeNext();
        }
        return this.org$buni$meldware$mail$store$StoreItemImpl$getInputStream$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public OutputStream getOuputStream() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getOuputStream4369506288762056207.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getOuputStream_4369506288762056207 getOuputStream_43695062887620562072 = new getOuputStream_4369506288762056207(methodInfo, interceptorArray);
            getOuputStream_43695062887620562072.setTargetObject(this);
            getOuputStream_43695062887620562072.typedTargetObject = this;
            getOuputStream_43695062887620562072.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (OutputStream)getOuputStream_43695062887620562072.invokeNext();
        }
        return this.org$buni$meldware$mail$store$StoreItemImpl$getOuputStream$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItemMetaData getMetaData() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMetaData8332461243561844888.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMetaData_8332461243561844888 getMetaData_83324612435618448882 = new getMetaData_8332461243561844888(methodInfo, interceptorArray);
            getMetaData_83324612435618448882.setTargetObject(this);
            getMetaData_83324612435618448882.typedTargetObject = this;
            getMetaData_83324612435618448882.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (StoreItemMetaData)getMetaData_83324612435618448882.invokeNext();
        }
        return this.org$buni$meldware$mail$store$StoreItemImpl$getMetaData$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public void streamClosed(StreamCloseEvent streamCloseEvent) throws IOException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_streamClosed7890526911085883131.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            streamClosed_7890526911085883131 streamClosed_78905269110858831312 = new streamClosed_7890526911085883131(methodInfo, interceptorArray);
            streamClosed_78905269110858831312.arg0 = streamCloseEvent;
            streamClosed_78905269110858831312.setTargetObject(this);
            streamClosed_78905269110858831312.typedTargetObject = this;
            streamClosed_78905269110858831312.setAdvisor((Advisor)aop$classAdvisor$aop);
            streamClosed_78905269110858831312.invokeNext();
        } else {
            this.org$buni$meldware$mail$store$StoreItemImpl$streamClosed$aop(streamCloseEvent);
        }
    }

    public static class getInputStream_N6796966186260264682
    extends MethodInvocation
    implements Untransformable {
        public StoreItemImpl typedTargetObject;

        public getInputStream_N6796966186260264682(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getInputStream_N6796966186260264682(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getInputStream_N6796966186260264682(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getInputStream_N6796966186260264682() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$StoreItemImpl$getInputStream$aop();
        }

        public Invocation copy() {
            getInputStream_N6796966186260264682 getInputStream_N67969661862602646822 = new getInputStream_N6796966186260264682(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getInputStream_N67969661862602646822.arguments = this.arguments;
            ((InvocationBase)getInputStream_N67969661862602646822).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getInputStream_N67969661862602646822).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getInputStream_N67969661862602646822).instanceResolver = ((InvocationBase)this).instanceResolver;
            getInputStream_N67969661862602646822.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getInputStream_N67969661862602646822).targetObject = ((InvocationBase)this).targetObject;
            return getInputStream_N67969661862602646822;
        }
    }

    public static class getOuputStream_4369506288762056207
    extends MethodInvocation
    implements Untransformable {
        public StoreItemImpl typedTargetObject;

        public getOuputStream_4369506288762056207(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getOuputStream_4369506288762056207(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getOuputStream_4369506288762056207(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getOuputStream_4369506288762056207() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$StoreItemImpl$getOuputStream$aop();
        }

        public Invocation copy() {
            getOuputStream_4369506288762056207 getOuputStream_43695062887620562072 = new getOuputStream_4369506288762056207(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getOuputStream_43695062887620562072.arguments = this.arguments;
            ((InvocationBase)getOuputStream_43695062887620562072).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getOuputStream_43695062887620562072).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getOuputStream_43695062887620562072).instanceResolver = ((InvocationBase)this).instanceResolver;
            getOuputStream_43695062887620562072.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getOuputStream_43695062887620562072).targetObject = ((InvocationBase)this).targetObject;
            return getOuputStream_43695062887620562072;
        }
    }

    public static class getMetaData_8332461243561844888
    extends MethodInvocation
    implements Untransformable {
        public StoreItemImpl typedTargetObject;

        public getMetaData_8332461243561844888(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMetaData_8332461243561844888(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMetaData_8332461243561844888(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMetaData_8332461243561844888() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$StoreItemImpl$getMetaData$aop();
        }

        public Invocation copy() {
            getMetaData_8332461243561844888 getMetaData_83324612435618448882 = new getMetaData_8332461243561844888(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMetaData_83324612435618448882.arguments = this.arguments;
            ((InvocationBase)getMetaData_83324612435618448882).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMetaData_83324612435618448882).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMetaData_83324612435618448882).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMetaData_83324612435618448882.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMetaData_83324612435618448882).targetObject = ((InvocationBase)this).targetObject;
            return getMetaData_83324612435618448882;
        }
    }

    public static class streamClosed_7890526911085883131
    extends MethodInvocation
    implements Untransformable {
        public StreamCloseEvent arg0;
        public StoreItemImpl typedTargetObject;

        public streamClosed_7890526911085883131(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public streamClosed_7890526911085883131(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public streamClosed_7890526911085883131(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public streamClosed_7890526911085883131() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$store$StoreItemImpl$streamClosed$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (StreamCloseEvent)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            streamClosed_7890526911085883131 streamClosed_78905269110858831312 = new streamClosed_7890526911085883131(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            streamClosed_78905269110858831312.arguments = this.arguments;
            ((InvocationBase)streamClosed_78905269110858831312).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)streamClosed_78905269110858831312).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)streamClosed_78905269110858831312).instanceResolver = ((InvocationBase)this).instanceResolver;
            streamClosed_78905269110858831312.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)streamClosed_78905269110858831312).targetObject = ((InvocationBase)this).targetObject;
            streamClosed_78905269110858831312.arg0 = this.arg0;
            return streamClosed_78905269110858831312;
        }
    }
}

