/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.jboss.logging.Logger;

public class BlobOutputStream
extends OutputStream {
    private Logger log = Logger.getLogger(BlobOutputStream.class);
    private ByteBuffer buffer;
    private AbstractStore store;
    private long position;
    private StoreItemMetaData meta;

    public BlobOutputStream(AbstractStore store, StoreItemMetaData meta) {
        this.store = store;
        this.meta = meta;
        this.buffer = ByteBuffer.allocate(meta.getPageSize());
        this.position = meta.getStartIndex();
    }

    public void write(int b) throws IOException {
        if (this.buffer.remaining() <= 0) {
            this.flush();
        }
        this.buffer.put((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int toCopy = Math.min(len, this.buffer.remaining());
        this.buffer.put(b, off, toCopy);
        if (this.buffer.remaining() <= 0) {
            this.flush();
        }
        if (len - toCopy > this.buffer.capacity()) {
            this.doWrite(b, off + toCopy, len - toCopy);
        } else if (len > toCopy) {
            this.buffer.put(b, off + toCopy, len - toCopy);
        }
    }

    private int doWrite(byte[] b, int off, int len) throws IOException {
        try {
            int numBytes = this.store.write(this.meta.getPid(), this.position, b, off, len);
            this.position += (long)numBytes;
            return numBytes;
        }
        catch (Exception e) {
            this.log.error("Failed to write to Store: ", e);
            throw new IOException(e.getClass() + ":" + e.getMessage());
        }
    }

    public void flush() throws IOException {
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            this.doWrite(this.buffer.array(), this.buffer.position(), this.buffer.remaining());
            this.buffer.clear();
        }
    }

    public void close() throws IOException {
        this.flush();
    }
}

