/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import org.buni.meldware.mail.store.Store;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItem;
import org.buni.meldware.mail.store.StoreItemImpl;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.util.HibernateUtil;
import org.buni.meldware.mail.util.io.IOUtil;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.id.GUID;

public abstract class AbstractStore
extends ServiceMBeanSupport
implements ServiceMBean,
Store,
Advised {
    protected EntityManager session;
    public static final int DEFAULT_PAGE_SIZE = 65536;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private static Logger log;
    private boolean compress = false;
    private int compressBufferSize = 8192;
    private int pageSize = 65536;
    private int bufferSize = 65536;
    private int startIndex = 0;
    private boolean hashed = false;
    private static ClassAdvisor aop$classAdvisor$aop;
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getStoreItem_N_2203723487785610040;
    private static WeakReference aop$MethodInfo_createStoreItem_N_5744478824573335271;
    private static WeakReference aop$MethodInfo_createMetaData4854029461500929713;
    private static WeakReference aop$MethodInfo_loadMetaData90473233630528184;
    private static WeakReference aop$MethodInfo_updateMetaData5071880378743828389;
    private static WeakReference aop$MethodInfo_listMetaData3524556747488871835;
    private static WeakReference aop$MethodInfo_close_N_6748842644855276541;
    private static WeakReference aop$MethodInfo_close_N_3241583693703287372;

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.AbstractStore"));
        log = Logger.getLogger(AbstractStore.class);
    }

    public void emInit() {
        if (this.session == null) {
            this.initEM();
        }
    }

    public synchronized void initEM() {
        try {
            if (this.session == null) {
                InitialContext ctx = new InitialContext();
                this.session = (EntityManager)ctx.lookup("java:/EntityManagers/mail");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract int read(Long var1, long var2, byte[] var4, int var5, int var6) throws StoreException;

    public abstract int write(Long var1, long var2, byte[] var4, int var5, int var6) throws StoreException;

    public abstract ByteBuffer getBuffer(Long var1, long var2, int var4) throws StoreException;

    public abstract InputStream getInputStream(Long var1, StoreItemMetaData var2) throws StoreException;

    public abstract OutputStream getOutputStream(Long var1, StoreItemMetaData var2) throws StoreException;

    protected Object createId() {
        return GUID.asString();
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItem org$buni$meldware$mail$store$AbstractStore$getStoreItem$aop(Long id) throws StoreException {
        StoreItemMetaData meta = this.loadMetaData(id);
        StoreItemImpl item = new StoreItemImpl(id, this);
        item.setMetaData(meta);
        return item;
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItem org$buni$meldware$mail$store$AbstractStore$createStoreItem$aop() throws StoreException {
        this.emInit();
        long id = this.doCreate();
        StoreItemImpl item = new StoreItemImpl(id, this);
        StoreItemMetaData meta = this.createMetaData(id);
        item.setMetaData(meta);
        return item;
    }

    public void commit() {
    }

    protected abstract Long doCreate() throws StoreException;

    @Tx(value=TxType.REQUIRED)
    public StoreItemMetaData org$buni$meldware$mail$store$AbstractStore$createMetaData$aop(Long id) throws StoreException {
        StoreItemMetaData meta;
        this.emInit();
        try {
            meta = new StoreItemMetaData();
            meta.setPid(id.longValue());
            meta.setCompressed(this.getCompress());
            meta.setPageSize(this.getPageSize());
            meta.setItemSize(0L);
            meta.setStartIndex((long)this.getStartIndex());
            meta.setHashed(this.getHashed());
            this.session.persist(meta);
            this.session.flush();
        }
        catch (HibernateException e) {
            throw new StoreException(e);
        }
        return meta;
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItemMetaData org$buni$meldware$mail$store$AbstractStore$loadMetaData$aop(Long id) throws StoreException {
        StoreItemMetaData meta;
        this.emInit();
        try {
            String sql = "from StoreItemMetaData md where md.pid=:pid";
            meta = HibernateUtil.singleResult(this.session.createQuery(sql).setParameter("pid", (Object)id), StoreItemMetaData.class);
            log.debug("Loaded MetaData: " + meta + " for Pid: " + id);
        }
        catch (HibernateException e) {
            throw new StoreException(e);
        }
        return meta;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$store$AbstractStore$updateMetaData$aop(StoreItemMetaData meta) throws StoreException {
        log.debug("Saving Meta Data for Id: " + meta.getPid());
        try {
            StoreItemMetaData nm = this.session.merge(meta);
            this.session.persist(nm);
            this.session.flush();
        }
        catch (HibernateException e) {
            throw new StoreException(e);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public String org$buni$meldware$mail$store$AbstractStore$listMetaData$aop() {
        this.emInit();
        Session session = null;
        StringBuffer sb = new StringBuffer();
        Query query = session.createQuery("from org.buni.meldware.mail.store.StoreItemMetaData");
        List l = query.list();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Tx(value=TxType.REQUIRED)
    public static void org$buni$meldware$mail$store$AbstractStore$close$aop(OutputStream out) throws StoreException {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            throw new StoreException("Failed to close output stream", e);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public static void org$buni$meldware$mail$store$AbstractStore$close$aop(InputStream in) throws StoreException {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            throw new StoreException("Failed to close input stream", e);
        }
    }

    public void setCompress(boolean b) {
        this.compress = b;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCompressBufferSize() {
        return this.compressBufferSize;
    }

    public void setCompressBufferSize(int compressBufferSize) {
        this.compressBufferSize = compressBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setHashed(boolean hashed) {
        this.hashed = hashed;
    }

    public boolean getHashed() {
        return this.hashed;
    }

    public void startService() throws Exception {
        this.validate();
        this.init();
    }

    public void validate() throws StoreException {
    }

    public void init() throws StoreException {
    }

    public void stopService() {
    }

    public void testNull(String name, Object o) throws StoreException {
        if (o == null) {
            throw new StoreException("Property: " + name + " has not been set");
        }
    }

    public String toString(Long id) throws IOException {
        StoreItem item = this.getStoreItem(id);
        InputStream in = item.getInputStream();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(IOUtil.toString(in, "US-ASCII"));
        sb.append("}");
        return sb.toString();
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        AbstractStore abstractStore = this;
        synchronized (abstractStore) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        AbstractStore abstractStore = this;
        synchronized (abstractStore) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItem getStoreItem(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getStoreItem_N_2203723487785610040.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getStoreItem_N2203723487785610040 getStoreItem_N22037234877856100402 = new getStoreItem_N2203723487785610040(methodInfo, interceptorArray);
            getStoreItem_N22037234877856100402.arg0 = l;
            getStoreItem_N22037234877856100402.setTargetObject(this);
            getStoreItem_N22037234877856100402.typedTargetObject = this;
            getStoreItem_N22037234877856100402.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (StoreItem)getStoreItem_N22037234877856100402.invokeNext();
        }
        return this.org$buni$meldware$mail$store$AbstractStore$getStoreItem$aop(l);
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItem createStoreItem() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createStoreItem_N_5744478824573335271.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createStoreItem_N5744478824573335271 createStoreItem_N57444788245733352712 = new createStoreItem_N5744478824573335271(methodInfo, interceptorArray);
            createStoreItem_N57444788245733352712.setTargetObject(this);
            createStoreItem_N57444788245733352712.typedTargetObject = this;
            createStoreItem_N57444788245733352712.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (StoreItem)createStoreItem_N57444788245733352712.invokeNext();
        }
        return this.org$buni$meldware$mail$store$AbstractStore$createStoreItem$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItemMetaData createMetaData(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createMetaData4854029461500929713.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createMetaData_4854029461500929713 createMetaData_48540294615009297132 = new createMetaData_4854029461500929713(methodInfo, interceptorArray);
            createMetaData_48540294615009297132.arg0 = l;
            createMetaData_48540294615009297132.setTargetObject(this);
            createMetaData_48540294615009297132.typedTargetObject = this;
            createMetaData_48540294615009297132.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (StoreItemMetaData)createMetaData_48540294615009297132.invokeNext();
        }
        return this.org$buni$meldware$mail$store$AbstractStore$createMetaData$aop(l);
    }

    @Tx(value=TxType.REQUIRED)
    public StoreItemMetaData loadMetaData(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_loadMetaData90473233630528184.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            loadMetaData_90473233630528184 loadMetaData_904732336305281842 = new loadMetaData_90473233630528184(methodInfo, interceptorArray);
            loadMetaData_904732336305281842.arg0 = l;
            loadMetaData_904732336305281842.setTargetObject(this);
            loadMetaData_904732336305281842.typedTargetObject = this;
            loadMetaData_904732336305281842.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (StoreItemMetaData)loadMetaData_904732336305281842.invokeNext();
        }
        return this.org$buni$meldware$mail$store$AbstractStore$loadMetaData$aop(l);
    }

    @Tx(value=TxType.REQUIRED)
    public void updateMetaData(StoreItemMetaData storeItemMetaData) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_updateMetaData5071880378743828389.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            updateMetaData_5071880378743828389 updateMetaData_50718803787438283892 = new updateMetaData_5071880378743828389(methodInfo, interceptorArray);
            updateMetaData_50718803787438283892.arg0 = storeItemMetaData;
            updateMetaData_50718803787438283892.setTargetObject(this);
            updateMetaData_50718803787438283892.typedTargetObject = this;
            updateMetaData_50718803787438283892.setAdvisor((Advisor)aop$classAdvisor$aop);
            updateMetaData_50718803787438283892.invokeNext();
        } else {
            this.org$buni$meldware$mail$store$AbstractStore$updateMetaData$aop(storeItemMetaData);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public String listMetaData() {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_listMetaData3524556747488871835.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            listMetaData_3524556747488871835 listMetaData_35245567474888718352 = new listMetaData_3524556747488871835(methodInfo, interceptorArray);
            listMetaData_35245567474888718352.setTargetObject(this);
            listMetaData_35245567474888718352.typedTargetObject = this;
            listMetaData_35245567474888718352.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (String)listMetaData_35245567474888718352.invokeNext();
        }
        return this.org$buni$meldware$mail$store$AbstractStore$listMetaData$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public static void close(OutputStream outputStream) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_close_N_6748842644855276541.get();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null) {
            close_N6748842644855276541 close_N67488426448552765412 = new close_N6748842644855276541(methodInfo, interceptorArray);
            close_N67488426448552765412.arg0 = outputStream;
            close_N67488426448552765412.setAdvisor((Advisor)aop$classAdvisor$aop);
            close_N67488426448552765412.invokeNext();
        } else {
            AbstractStore.org$buni$meldware$mail$store$AbstractStore$close$aop(outputStream);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public static void close(InputStream inputStream) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_close_N_3241583693703287372.get();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null) {
            close_N3241583693703287372 close_N32415836937032873722 = new close_N3241583693703287372(methodInfo, interceptorArray);
            close_N32415836937032873722.arg0 = inputStream;
            close_N32415836937032873722.setAdvisor((Advisor)aop$classAdvisor$aop);
            close_N32415836937032873722.invokeNext();
        } else {
            AbstractStore.org$buni$meldware$mail$store$AbstractStore$close$aop(inputStream);
        }
    }

    public static class getStoreItem_N2203723487785610040
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public AbstractStore typedTargetObject;

        public getStoreItem_N2203723487785610040(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getStoreItem_N2203723487785610040(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getStoreItem_N2203723487785610040(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getStoreItem_N2203723487785610040() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$AbstractStore$getStoreItem$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getStoreItem_N2203723487785610040 getStoreItem_N22037234877856100402 = new getStoreItem_N2203723487785610040(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getStoreItem_N22037234877856100402.arguments = this.arguments;
            ((InvocationBase)getStoreItem_N22037234877856100402).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getStoreItem_N22037234877856100402).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getStoreItem_N22037234877856100402).instanceResolver = ((InvocationBase)this).instanceResolver;
            getStoreItem_N22037234877856100402.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getStoreItem_N22037234877856100402).targetObject = ((InvocationBase)this).targetObject;
            getStoreItem_N22037234877856100402.arg0 = this.arg0;
            return getStoreItem_N22037234877856100402;
        }
    }

    public static class createStoreItem_N5744478824573335271
    extends MethodInvocation
    implements Untransformable {
        public AbstractStore typedTargetObject;

        public createStoreItem_N5744478824573335271(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createStoreItem_N5744478824573335271(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createStoreItem_N5744478824573335271(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createStoreItem_N5744478824573335271() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$AbstractStore$createStoreItem$aop();
        }

        public Invocation copy() {
            createStoreItem_N5744478824573335271 createStoreItem_N57444788245733352712 = new createStoreItem_N5744478824573335271(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createStoreItem_N57444788245733352712.arguments = this.arguments;
            ((InvocationBase)createStoreItem_N57444788245733352712).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createStoreItem_N57444788245733352712).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createStoreItem_N57444788245733352712).instanceResolver = ((InvocationBase)this).instanceResolver;
            createStoreItem_N57444788245733352712.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createStoreItem_N57444788245733352712).targetObject = ((InvocationBase)this).targetObject;
            return createStoreItem_N57444788245733352712;
        }
    }

    public static class createMetaData_4854029461500929713
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public AbstractStore typedTargetObject;

        public createMetaData_4854029461500929713(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createMetaData_4854029461500929713(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createMetaData_4854029461500929713(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createMetaData_4854029461500929713() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$AbstractStore$createMetaData$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            createMetaData_4854029461500929713 createMetaData_48540294615009297132 = new createMetaData_4854029461500929713(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createMetaData_48540294615009297132.arguments = this.arguments;
            ((InvocationBase)createMetaData_48540294615009297132).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createMetaData_48540294615009297132).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createMetaData_48540294615009297132).instanceResolver = ((InvocationBase)this).instanceResolver;
            createMetaData_48540294615009297132.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createMetaData_48540294615009297132).targetObject = ((InvocationBase)this).targetObject;
            createMetaData_48540294615009297132.arg0 = this.arg0;
            return createMetaData_48540294615009297132;
        }
    }

    public static class loadMetaData_90473233630528184
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public AbstractStore typedTargetObject;

        public loadMetaData_90473233630528184(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public loadMetaData_90473233630528184(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public loadMetaData_90473233630528184(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public loadMetaData_90473233630528184() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$AbstractStore$loadMetaData$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            loadMetaData_90473233630528184 loadMetaData_904732336305281842 = new loadMetaData_90473233630528184(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            loadMetaData_904732336305281842.arguments = this.arguments;
            ((InvocationBase)loadMetaData_904732336305281842).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)loadMetaData_904732336305281842).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)loadMetaData_904732336305281842).instanceResolver = ((InvocationBase)this).instanceResolver;
            loadMetaData_904732336305281842.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)loadMetaData_904732336305281842).targetObject = ((InvocationBase)this).targetObject;
            loadMetaData_904732336305281842.arg0 = this.arg0;
            return loadMetaData_904732336305281842;
        }
    }

    public static class updateMetaData_5071880378743828389
    extends MethodInvocation
    implements Untransformable {
        public StoreItemMetaData arg0;
        public AbstractStore typedTargetObject;

        public updateMetaData_5071880378743828389(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public updateMetaData_5071880378743828389(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public updateMetaData_5071880378743828389(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public updateMetaData_5071880378743828389() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$store$AbstractStore$updateMetaData$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (StoreItemMetaData)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            updateMetaData_5071880378743828389 updateMetaData_50718803787438283892 = new updateMetaData_5071880378743828389(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            updateMetaData_50718803787438283892.arguments = this.arguments;
            ((InvocationBase)updateMetaData_50718803787438283892).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)updateMetaData_50718803787438283892).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)updateMetaData_50718803787438283892).instanceResolver = ((InvocationBase)this).instanceResolver;
            updateMetaData_50718803787438283892.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)updateMetaData_50718803787438283892).targetObject = ((InvocationBase)this).targetObject;
            updateMetaData_50718803787438283892.arg0 = this.arg0;
            return updateMetaData_50718803787438283892;
        }
    }

    public static class listMetaData_3524556747488871835
    extends MethodInvocation
    implements Untransformable {
        public AbstractStore typedTargetObject;

        public listMetaData_3524556747488871835(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public listMetaData_3524556747488871835(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public listMetaData_3524556747488871835(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public listMetaData_3524556747488871835() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$AbstractStore$listMetaData$aop();
        }

        public Invocation copy() {
            listMetaData_3524556747488871835 listMetaData_35245567474888718352 = new listMetaData_3524556747488871835(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            listMetaData_35245567474888718352.arguments = this.arguments;
            ((InvocationBase)listMetaData_35245567474888718352).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)listMetaData_35245567474888718352).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)listMetaData_35245567474888718352).instanceResolver = ((InvocationBase)this).instanceResolver;
            listMetaData_35245567474888718352.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)listMetaData_35245567474888718352).targetObject = ((InvocationBase)this).targetObject;
            return listMetaData_35245567474888718352;
        }
    }

    public static class close_N6748842644855276541
    extends MethodInvocation
    implements Untransformable {
        public OutputStream arg0;

        public close_N6748842644855276541(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public close_N6748842644855276541(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public close_N6748842644855276541(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public close_N6748842644855276541() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            AbstractStore.org$buni$meldware$mail$store$AbstractStore$close$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (OutputStream)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            close_N6748842644855276541 close_N67488426448552765412 = new close_N6748842644855276541(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            close_N67488426448552765412.arguments = this.arguments;
            ((InvocationBase)close_N67488426448552765412).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)close_N67488426448552765412).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)close_N67488426448552765412).instanceResolver = ((InvocationBase)this).instanceResolver;
            close_N67488426448552765412.arg0 = this.arg0;
            return close_N67488426448552765412;
        }
    }

    public static class close_N3241583693703287372
    extends MethodInvocation
    implements Untransformable {
        public InputStream arg0;

        public close_N3241583693703287372(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public close_N3241583693703287372(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public close_N3241583693703287372(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public close_N3241583693703287372() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            AbstractStore.org$buni$meldware$mail$store$AbstractStore$close$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (InputStream)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            close_N3241583693703287372 close_N32415836937032873722 = new close_N3241583693703287372(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            close_N32415836937032873722.arguments = this.arguments;
            ((InvocationBase)close_N32415836937032873722).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)close_N32415836937032873722).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)close_N32415836937032873722).instanceResolver = ((InvocationBase)this).instanceResolver;
            close_N32415836937032873722.arg0 = this.arg0;
            return close_N32415836937032873722;
        }
    }
}

