/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.spam;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.MailHeaders;
import org.buni.meldware.mail.message.Message;
import org.buni.meldware.mail.spam.JasenFilter;
import org.buni.panto.BodyHeader;
import org.buni.panto.ContentHandler;
import org.buni.panto.MimeParser;
import org.jasen.JasenScanner;
import org.jasen.error.JasenException;
import org.jasen.interfaces.JasenMessage;
import org.jasen.interfaces.JasenScanResult;

public class JasenFilterImpl
implements JasenFilter {
    private MailBodyManager mgr;
    private static final Log log = Log.getLog(JasenFilterImpl.class);

    public Message send(Message message) {
        Mail mail = (Mail)message;
        try {
            double d = this.scan(mail);
            String prob = String.valueOf(d);
            mail.getMailHeaders().addHeader("X-meldware-spam-score", prob);
        }
        catch (Exception e) {
            log.warn((Throwable)e, (Object)"Failed to scan message");
            e.printStackTrace();
        }
        return mail;
    }

    public double scan(Mail mail) {
        try {
            MailHeaders header = mail.getMailHeaders();
            MimeMessage mm = this.extractHeader(header);
            JasenTextExtractHandler h = new JasenTextExtractHandler();
            MimeParser p = new MimeParser();
            p.setContentHandler((ContentHandler)h);
            p.parse(mail.getRawStream(this.mgr));
            String html = h.getHtml();
            String text = h.getText();
            String from = header.getFrom();
            InternetAddress ia = new InternetAddress(mail.getSender().toSMTPString());
            SimpleJasenMessage msg = new SimpleJasenMessage(text, html, from, ia);
            log.debug("Scanning message from %s:", new Object[]{from});
            JasenScanResult result = JasenScanner.getInstance().scan(mm, (JasenMessage)msg);
            return result.getProbability();
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
        catch (IOException e) {
            throw new MailException(e);
        }
        catch (JasenException e) {
            throw new MailException(e);
        }
    }

    private MimeMessage extractHeader(MailHeaders headers) throws MessagingException {
        MimeMessage mm = new MimeMessage(null);
        for (String line : headers) {
            mm.addHeaderLine(line);
        }
        return mm;
    }

    public void start() throws JasenException {
        log.info((Object)"Initialising jASEN");
        JasenScanner.getInstance().init();
    }

    public void setMailBodyManager(MailBodyManager mgr) {
        this.mgr = mgr;
    }

    public MailBodyManager getMailBodyManager() {
        return this.mgr;
    }

    private static class SimpleJasenMessage
    implements JasenMessage {
        private static final long serialVersionUID = 1L;
        private String text;
        private String html;
        private String sender;
        private InternetAddress from;

        public SimpleJasenMessage(String text, String html, String sender, InternetAddress from) {
            this.text = text;
            this.html = html;
            this.sender = sender;
            this.from = from;
        }

        public String[] getAttachmentNames() throws JasenException {
            return null;
        }

        public String getEnvelopeSender() throws JasenException {
            return this.sender;
        }

        public InternetAddress getFrom() throws JasenException {
            return this.from;
        }

        public String getHtmlPart() throws JasenException {
            return this.html;
        }

        public String getTextPart() throws JasenException {
            return this.text;
        }
    }

    private static class JasenTextExtractHandler
    implements ContentHandler {
        private StringBuilder text = new StringBuilder();
        private StringBuilder html = new StringBuilder();

        private JasenTextExtractHandler() {
        }

        public String getText() {
            return this.text.toString();
        }

        public String getHtml() {
            return this.html.toString();
        }

        public void body(BodyHeader bd, InputStream in) throws IOException {
            String type = bd.getContentType().getType();
            String subType = bd.getContentType().getSubType();
            StringBuilder sb = type == null ? this.text : ("html".equals(subType) ? this.html : ("xhtml".equals(subType) ? this.html : ("text".equals(type) ? this.text : null)));
            if (sb != null) {
                Charset cs;
                String charset = (String)bd.getContentType().getParameters().get("charset");
                charset = charset != null ? charset : "US-ASCII";
                try {
                    cs = Charset.forName(charset);
                }
                catch (Exception exception) {
                    cs = Charset.defaultCharset();
                }
                InputStreamReader r = new InputStreamReader(in, cs);
                char[] data = new char[8192];
                int numChars = 0;
                while ((numChars = r.read(data)) != -1) {
                    sb.append(data, 0, numChars);
                }
                sb.append("\r\n");
            } else {
                byte[] b = new byte[8192];
                while (in.read(b) != -1) {
                }
            }
        }

        public void endBodyPart() {
        }

        public void endHeader() {
        }

        public void endMessage() {
        }

        public void endMultipart() {
        }

        public void epilogue(InputStream in) throws IOException {
            byte[] b = new byte[8192];
            while (in.read(b) != -1) {
            }
        }

        public void field(String arg0) {
        }

        public void preamble(InputStream in) throws IOException {
            byte[] b = new byte[8192];
            while (in.read(b) != -1) {
            }
        }

        public void raw(InputStream arg0) throws IOException {
        }

        public void startBodyPart() {
        }

        public void startHeader() {
        }

        public void startMessage() {
        }

        public void startMultipart(BodyHeader arg0) {
        }
    }
}

