/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.jboss.logging.Logger;

public class CmdHELO
implements SMTPHandler,
SMTPConstants {
    private static final Logger jblog = Logger.getLogger(CmdHELO.class);
    public static final String COMMAND = "HELO";

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        jblog.debug("HELO command handler called");
        SMTPResponse response = new SMTPResponse(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String remoteaddr = this.getRemoteAddr(request.arguments());
        if (remoteaddr != null && !remoteaddr.equals("")) {
            SMTPProtocolInstance inst = (SMTPProtocolInstance)protocol;
            remoteaddr = remoteaddr.trim();
            writer.println("250 " + protocol.getProperty("Servername") + " Hello " + remoteaddr + " (" + request.getRemoteAddr() + ")");
            inst.setState("h", remoteaddr);
        } else {
            writer.println("501 Domain address required: HELO");
        }
        writer.flush();
        return response;
    }

    private String getRemoteAddr(Iterator iter) {
        String remote = null;
        if (iter.hasNext() && iter != null) {
            remote = (String)iter.next();
        }
        return remote;
    }
}

