/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;

public class CmdUSER
extends AbstractCommand
implements POP3Handler,
POP3UserMessages {
    public static final String COMMAND = "USER";
    private static final Logger log = Logger.getLogger(CmdUSER.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug("USER command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        boolean tlsRequired = protocol.getPropertyBool("RequireTls");
        String[] arguments = request.getArguments();
        if (this.verifyState(protocol, writer, 0) && this.verifyArgumentCount(arguments, writer, 1)) {
            if (tlsRequired && !protocol.isSecure()) {
                writer.println("-ERR Encryption required for requested authentication mechanism");
                writer.flush();
                return response;
            }
            if (protocol.getUsername() != null) {
                writer.println("-ERR User already specified.");
                writer.flush();
                return response;
            }
            String username = arguments[0];
            username.trim().toLowerCase();
            if (username.length() > 0) {
                protocol.setUsername(username);
                log.warn("pop username set to " + username);
                writer.println("+OK");
            } else {
                writer.println("-ERR Invalid user.");
            }
        }
        writer.flush();
        return response;
    }
}

