/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.Security;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.pop3.MutablePOP3Request;
import org.buni.meldware.mail.pop3.POP3Constants;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;

public class CmdSTLS
extends AbstractCommand
implements POP3Handler,
POP3UserMessages,
POP3Constants {
    public static final String COMMAND = "STLS";
    private static final Logger log = Logger.getLogger(CmdSTLS.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug("STLS command handler called");
        POP3ProtocolInstance popProtocol = protocol;
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        if (popProtocol.getState() != 0) {
            writer.println("-ERR Command not allowed at this time");
        } else if (this.verifyArgumentCount(request.getArguments(), writer, 0)) {
            writer.println("+OK");
            Security.addProvider((java.security.Provider)new Provider());
            SSLSocketFactory factory = (SSLSocketFactory)popProtocol.getProperty("SslSocketFactory");
            Socket oldSocket = ((MutablePOP3Request)request).getSocket();
            final SSLSocket newSocket = (SSLSocket)factory.createSocket(oldSocket, oldSocket.getLocalAddress().getHostName(), oldSocket.getLocalPort(), true);
            newSocket.setNeedClientAuth(protocol.getPropertyBool("RequireClientCert"));
            newSocket.setUseClientMode(false);
            final POP3ProtocolInstance tempProtocol = protocol;
            newSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                public void handshakeCompleted(HandshakeCompletedEvent event) {
                    log.debug("HS completed");
                    tempProtocol.setSecure(true);
                    Object localAddr = tempProtocol.getState("local address");
                    Object remoteAddr = tempProtocol.getState("client address");
                    tempProtocol.resetState();
                    tempProtocol.setState("local address", localAddr);
                    tempProtocol.setState("client address", remoteAddr);
                    log.debug("State reset");
                    Certificate[] certs = null;
                    try {
                        certs = newSocket.getSession().getPeerCertificates();
                        int j = certs.length - 1;
                        while (j >= 0) {
                            log.debug(certs[j]);
                            --j;
                        }
                    }
                    catch (SSLPeerUnverifiedException e) {
                        e.printStackTrace();
                    }
                }
            });
            response.setSocketOverride(newSocket);
        }
        writer.flush();
        return response;
    }
}

