/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;

public class CmdSTAT
extends AbstractCommand
implements POP3Handler,
POP3UserMessages {
    public static final String COMMAND = "STAT";
    private static final Logger log = Logger.getLogger(CmdSTAT.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException, MailException {
        log.debug("STAT command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        if (this.verifyState(protocol, writer, 1)) {
            List<MessageData> messages = protocol.getInboxMailList();
            long totalCount = 0L;
            long totalSize = 0L;
            int index = 0;
            while (index < messages.size()) {
                ++totalCount;
                MessageData message = messages.get(index);
                if (!message.isDeleted()) {
                    totalSize += message.getSize();
                }
                ++index;
            }
            writer.println("+OK " + totalCount + " " + totalSize);
        }
        writer.flush();
        return response;
    }
}

