/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.buni.meldware.mail.AbstractProtocol;
import org.buni.meldware.mail.AbstractResponse;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.Response;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.pop3.MutablePOP3Request;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POP3ProtocolInstance
extends AbstractProtocol
implements Protocol,
Advised {
    private static final long serialVersionUID = 3832907641444774452L;
    private Logger log = Logger.getLogger(POP3ProtocolInstance.class);
    private String apop = null;
    public static final int STATE_AUTHORIZATION = 0;
    public static final int STATE_TRANSACTION = 1;
    public static final int STATE_UPDATE = 2;
    private Map handlers;
    private int state;
    private String username = null;
    private Mailbox mailbox = null;
    private MailboxService mailboxManager = null;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.pop3.POP3ProtocolInstance"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getMessageAt_N_5499269579338917842;
    private static WeakReference aop$MethodInfo_commit4252841159663424633;
    private static WeakReference aop$MethodInfo_handleCleanup_N_8779700852864121194;

    public POP3ProtocolInstance(Map handlers, ObjectName parent, MailboxService mailboxManager) {
        super(parent);
        this.handlers = handlers;
        this.mailboxManager = mailboxManager;
        this.state = 0;
    }

    @Override
    public void greet(OutputStream stream) throws IOException {
        String id = this.generateIdStringForAPOP((String)this.getProperty("Servername"));
        PrintWriter writer = AbstractResponse.getWrappedWriter(new PrintWriter(stream));
        String display = "+OK POP3 Server (Meldware Mail POP3 Server version 0.7) ready " + id;
        this.log.debug(display);
        writer.println(display);
        writer.flush();
    }

    private String generateIdStringForAPOP(String servername) {
        String retval;
        String threadid = "" + Thread.currentThread().getId();
        String thetime = "" + System.currentTimeMillis();
        this.apop = retval = "<" + threadid + "." + thetime + "@" + servername + ">";
        return retval;
    }

    @Override
    public Request parseRequest(InputStream stream, Socket socket) throws IOException {
        MutablePOP3Request request = new MutablePOP3Request(this, stream);
        String commandString = this.readCommand(stream);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got commandString: " + commandString);
        }
        String[] command = this.parseCommand(commandString);
        request.setCommand(command[0].trim());
        if (command[1] != null && command[1].trim().length() > 0) {
            StringTokenizer tok = new StringTokenizer(command[1].trim(), " ");
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken();
                request.addArgument(arg);
            }
        }
        request.setSocket(socket);
        return request;
    }

    @Override
    public Response handleRequest(OutputStream stream, Request request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("HandleRequest called with request = " + (request == null ? "true" : "false"));
            this.log.debug("HandleRequest called with command = " + (request == null ? "null" : ((POP3Request)request).getCommand()));
        }
        POP3Handler handler = (POP3Handler)this.handlers.get(((POP3Request)request).getCommand());
        POP3Response response = null;
        if (handler != null) {
            try {
                response = handler.handleRequest(stream, (POP3Request)request, this);
            }
            catch (IOException e) {
                this.log.error("Command: " + handler.getClass().getSimpleName(), e);
                this.handleIOError(stream);
            }
            catch (MailException e) {
                this.log.error("Command: " + handler.getClass().getSimpleName(), e);
                this.handleIOError(stream);
            }
        } else {
            try {
                response = new POP3Response(request, stream, this);
                PrintWriter writer = response.getWriter();
                writer.println("-ERR " + this.getProperty("Servername") + " Syntax error, command unrecognized: " + ((POP3Request)request).getCommand());
                writer.flush();
            }
            catch (IOException ioe) {
                this.log.error(ioe);
                response = (POP3Response)this.handleIOError(stream);
            }
        }
        return response;
    }

    public String readResponse(Request request) throws IOException {
        return this.readCommand(((POP3Request)request).getInputStream());
    }

    @Override
    public Response handleIOError(OutputStream stream) {
        this.log.error("Handle IO Error");
        return null;
    }

    @Override
    public String getName() {
        return "POP3";
    }

    public void setProperties(List properties) {
    }

    public Element getProperties() {
        return null;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public void setMailbox(Mailbox mailbox) {
        this.mailbox = mailbox;
    }

    @Override
    public void greet(SocketChannel ioChannel) throws IOException {
        String id = this.generateIdStringForAPOP((String)this.getProperty("Servername"));
        String display = "+OK POP3 Server (JBMAIL POP3 Server version 0.2) ready " + id;
        this.log.debug(display);
        char[] chr = display.toCharArray();
        ByteBuffer buffer = ByteBuffer.allocate(chr.length * 2);
        buffer.asCharBuffer().put(chr);
        ioChannel.write(buffer);
    }

    public String getApopId() {
        return this.apop;
    }

    public Mailbox getMailboxForUser(String username) throws MailException {
        Mailbox folder = null;
        if (this.state == 0) {
            folder = this.mailboxManager.getMailboxByAlias(username);
        }
        return folder;
    }

    public MailboxService getMailboxService() {
        return this.mailboxManager;
    }

    public boolean lock(Folder folder) {
        try {
            return this.mailboxManager.lock(this.username, folder, new Date((Long)this.getState("life")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<MessageData> getInboxMailList() {
        MailboxService service = this.getMailboxService();
        Folder f = this.getMailbox().getDefaultInFolder();
        List<MessageData> data = service.getMailListForFolder(f, false);
        return data;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageData org$buni$meldware$mail$pop3$POP3ProtocolInstance$getMessageAt$aop(int id) {
        return this.getMailboxService().getMailAt(this.getMailbox().getDefaultInFolder(), id);
    }

    @Tx(value=TxType.REQUIRESNEW)
    public boolean org$buni$meldware$mail$pop3$POP3ProtocolInstance$commit$aop() {
        return this.getMailboxService().commit(this.getUsername());
    }

    public boolean markDeltedAt(int i) {
        return this.getMailboxService().markDeleted(this.getMailbox(), i);
    }

    public boolean deleteMarked() {
        return this.getMailboxService().deleteMarked(this.getMailbox());
    }

    @Tx(value=TxType.REQUIRESNEW)
    public void org$buni$meldware$mail$pop3$POP3ProtocolInstance$handleCleanup$aop(OutputStream out) {
        try {
            this.getMailboxService().unmarkDeleted(this.getMailbox());
        }
        catch (Exception exception) {}
        try {
            this.getMailboxService().release(this.getUsername(), (Folder)this.getMailbox());
        }
        catch (Exception exception) {}
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        POP3ProtocolInstance pOP3ProtocolInstance = this;
        synchronized (pOP3ProtocolInstance) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        POP3ProtocolInstance pOP3ProtocolInstance = this;
        synchronized (pOP3ProtocolInstance) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public MessageData getMessageAt(int n) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMessageAt_N_5499269579338917842.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMessageAt_N5499269579338917842 getMessageAt_N54992695793389178422 = new getMessageAt_N5499269579338917842(methodInfo, interceptorArray);
            getMessageAt_N54992695793389178422.arg0 = n;
            getMessageAt_N54992695793389178422.setTargetObject(this);
            getMessageAt_N54992695793389178422.typedTargetObject = this;
            getMessageAt_N54992695793389178422.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageData)getMessageAt_N54992695793389178422.invokeNext();
        }
        return this.org$buni$meldware$mail$pop3$POP3ProtocolInstance$getMessageAt$aop(n);
    }

    @Tx(value=TxType.REQUIRESNEW)
    public boolean commit() {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_commit4252841159663424633.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            commit_4252841159663424633 commit_42528411596634246332 = new commit_4252841159663424633(methodInfo, interceptorArray);
            commit_42528411596634246332.setTargetObject(this);
            commit_42528411596634246332.typedTargetObject = this;
            commit_42528411596634246332.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)commit_42528411596634246332.invokeNext();
        }
        return this.org$buni$meldware$mail$pop3$POP3ProtocolInstance$commit$aop();
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public void handleCleanup(OutputStream outputStream) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_handleCleanup_N_8779700852864121194.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            handleCleanup_N8779700852864121194 handleCleanup_N87797008528641211942 = new handleCleanup_N8779700852864121194(methodInfo, interceptorArray);
            handleCleanup_N87797008528641211942.arg0 = outputStream;
            handleCleanup_N87797008528641211942.setTargetObject(this);
            handleCleanup_N87797008528641211942.typedTargetObject = this;
            handleCleanup_N87797008528641211942.setAdvisor((Advisor)aop$classAdvisor$aop);
            handleCleanup_N87797008528641211942.invokeNext();
        } else {
            this.org$buni$meldware$mail$pop3$POP3ProtocolInstance$handleCleanup$aop(outputStream);
        }
    }

    public static class getMessageAt_N5499269579338917842
    extends MethodInvocation
    implements Untransformable {
        public int arg0;
        public POP3ProtocolInstance typedTargetObject;

        public getMessageAt_N5499269579338917842(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMessageAt_N5499269579338917842(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMessageAt_N5499269579338917842(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMessageAt_N5499269579338917842() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$pop3$POP3ProtocolInstance$getMessageAt$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Integer)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Integer(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getMessageAt_N5499269579338917842 getMessageAt_N54992695793389178422 = new getMessageAt_N5499269579338917842(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMessageAt_N54992695793389178422.arguments = this.arguments;
            ((InvocationBase)getMessageAt_N54992695793389178422).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMessageAt_N54992695793389178422).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMessageAt_N54992695793389178422).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMessageAt_N54992695793389178422.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMessageAt_N54992695793389178422).targetObject = ((InvocationBase)this).targetObject;
            getMessageAt_N54992695793389178422.arg0 = this.arg0;
            return getMessageAt_N54992695793389178422;
        }
    }

    public static class commit_4252841159663424633
    extends MethodInvocation
    implements Untransformable {
        public POP3ProtocolInstance typedTargetObject;

        public commit_4252841159663424633(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public commit_4252841159663424633(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public commit_4252841159663424633(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public commit_4252841159663424633() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$pop3$POP3ProtocolInstance$commit$aop());
        }

        public Invocation copy() {
            commit_4252841159663424633 commit_42528411596634246332 = new commit_4252841159663424633(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            commit_42528411596634246332.arguments = this.arguments;
            ((InvocationBase)commit_42528411596634246332).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)commit_42528411596634246332).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)commit_42528411596634246332).instanceResolver = ((InvocationBase)this).instanceResolver;
            commit_42528411596634246332.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)commit_42528411596634246332).targetObject = ((InvocationBase)this).targetObject;
            return commit_42528411596634246332;
        }
    }

    public static class handleCleanup_N8779700852864121194
    extends MethodInvocation
    implements Untransformable {
        public OutputStream arg0;
        public POP3ProtocolInstance typedTargetObject;

        public handleCleanup_N8779700852864121194(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public handleCleanup_N8779700852864121194(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public handleCleanup_N8779700852864121194(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public handleCleanup_N8779700852864121194() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$pop3$POP3ProtocolInstance$handleCleanup$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (OutputStream)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            handleCleanup_N8779700852864121194 handleCleanup_N87797008528641211942 = new handleCleanup_N8779700852864121194(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            handleCleanup_N87797008528641211942.arguments = this.arguments;
            ((InvocationBase)handleCleanup_N87797008528641211942).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)handleCleanup_N87797008528641211942).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)handleCleanup_N87797008528641211942).instanceResolver = ((InvocationBase)this).instanceResolver;
            handleCleanup_N87797008528641211942.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)handleCleanup_N87797008528641211942).targetObject = ((InvocationBase)this).targetObject;
            handleCleanup_N87797008528641211942.arg0 = this.arg0;
            return handleCleanup_N87797008528641211942;
        }
    }
}

