/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3;

import java.lang.reflect.Method;
import java.util.Map;
import javax.naming.InitialContext;
import javax.net.ssl.SSLSocketFactory;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.pop3.POP3Constants;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3ProtocolMBean;
import org.buni.meldware.mail.pop3.handlers.POP3Handlers;
import org.buni.meldware.mail.userrepository.UserRepository;
import org.jboss.security.SecurityDomain;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class POP3Protocol
extends ServiceMBeanSupport
implements POP3ProtocolMBean,
POP3Constants {
    InitialContext ctx;
    Map handlers;
    Map properties;
    private MailboxService mailboxManager;
    protected String sslDomain;
    private String servername;
    private boolean tlsEnabled;
    private boolean tlsRequired;
    private boolean requireClientCert;
    private UserRepository userRepository;
    private UserRepository apopUserRepository;
    private SSLSocketFactory sslSocketFactory;

    public POP3Protocol() {
        try {
            this.handlers = POP3Handlers.instance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "POP3";
    }

    public Element getProperties() {
        return null;
    }

    public Protocol createInstance() {
        return new POP3ProtocolInstance(this.handlers, this.getServiceName(), this.mailboxManager);
    }

    public void setSecurityDomain(String domainName) {
        try {
            this.log.info("pop3 security domain set to " + domainName);
            this.sslDomain = domainName;
        }
        catch (RuntimeException e) {
            this.log.error("Error", e);
            throw e;
        }
    }

    public String getSecurityDomain() {
        return this.sslDomain;
    }

    protected void startService() throws Exception {
        this.log.debug("startService()");
        this.setupSSLSocketFactory();
    }

    private void setupSSLSocketFactory() throws RuntimeException {
        this.log.info("setupSSLSocketFactory called.");
        SSLSocketFactory sslSocketFactory = null;
        if (this.sslDomain != null) {
            this.log.info("setting up socket factory for domain " + this.sslDomain);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> sfClass;
                try {
                    sfClass = loader.loadClass("org.jboss.security.ssl.DomainSocketFactory");
                    sslSocketFactory = (SSLSocketFactory)sfClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create SSLSocketFactory", e);
                }
                sfClass = sslSocketFactory.getClass();
                InitialContext ctx = new InitialContext();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = sfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)sslSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.error("Socket factory does not support setSecurityDomain(SecurityDomain)");
                throw new RuntimeException("Could not set up security for TLS", e);
            }
            catch (Exception e) {
                this.log.error("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory", e);
                throw new RuntimeException("Could not set up security for TLS", e);
            }
        }
        if (this.isTlsEnabled()) {
            throw new RuntimeException("tls-enabled was set to true, but no SecurityDomain was specified");
        }
        this.log.info("socket factory is " + sslSocketFactory);
        this.setSslSocketFactory(sslSocketFactory);
    }

    public void setMailboxManager(MailboxService mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public MailboxService getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean isRequireClientCert() {
        return this.requireClientCert;
    }

    public void setRequireClientCert(boolean requireClientCert) {
        this.requireClientCert = requireClientCert;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public boolean isRequireTls() {
        return this.tlsRequired;
    }

    public void setRequireTls(boolean requireTls) {
        this.tlsRequired = requireTls;
    }

    public UserRepository getAPOPUserRepository() {
        return this.apopUserRepository;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setAPOPUserRepository(UserRepository userRepository) {
        this.apopUserRepository = userRepository;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public Class getProtocolInterfaceClass() {
        return POP3ProtocolMBean.class;
    }

    public String getSslDomain() {
        return this.getSecurityDomain();
    }

    public void setSslDomain(String sslDomain) {
        this.setSecurityDomain(sslDomain);
    }
}

