/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.maillistener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.MailListener;
import org.buni.meldware.mail.maillistener.ForwarderMailListenerMBean;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ForwarderMailListener
implements ForwarderMailListenerMBean,
MailListener {
    private Map<String, String> forwardConfig = new HashMap<String, String>();
    private static final Logger log = Logger.getLogger(ForwarderMailListener.class);

    public void create() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void setConfiguration(Element xml) {
        if (xml != null) {
            NodeList forwardAttributes = xml.getChildNodes();
            int len = forwardAttributes.getLength();
            int x = 0;
            while (x < len) {
                Node attr = forwardAttributes.item(x);
                if ("forward".equals(attr.getNodeName())) {
                    String name = attr.getAttributes().getNamedItem("originalAddress").getNodeValue();
                    String value = attr.getFirstChild().getNodeValue();
                    if (value.indexOf(64) != -1) {
                        this.forwardConfig.put(name, value);
                    } else {
                        log.error("Can not accept forward value of " + value + ".  It is not of format user@domain.");
                    }
                }
                ++x;
            }
        } else {
            log.warn("Could not configure ForwarderMailListener.  Configuration is null.");
        }
    }

    public Message send(Message msg) throws MailException {
        Object retMsg = msg;
        if (msg != null) {
            ArrayList<MailAddress> forwardMailAddress = new ArrayList<MailAddress>();
            Mail mail = (Mail)msg;
            for (MailAddress currentAddress : mail.getTo()) {
                String domain = currentAddress.getDomain();
                String user = currentAddress.getUser();
                String value = this.forwardConfig.get(domain);
                if (value == null) {
                    value = this.forwardConfig.get(user);
                }
                if (value == null) {
                    value = this.forwardConfig.get(String.valueOf(user) + "@" + domain);
                }
                if (value != null) {
                    MailAddress newAddr = MailAddress.parseSMTPStyle(value);
                    forwardMailAddress.add(newAddr);
                    continue;
                }
                forwardMailAddress.add(currentAddress);
            }
            retMsg = new ForwardMail(mail, forwardMailAddress);
        }
        return retMsg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForwardMail
    extends Mail {
        private static final long serialVersionUID = 1L;
        List<MailAddress> to;

        ForwardMail(Mail mail, List<MailAddress> to) {
            super(mail);
            this.to = to;
        }

        public List<MailAddress> getTo() {
            return this.to;
        }
    }
}

