/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailhandler.localmailbox;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.MailListener;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.mailbox.MessageDataUtil;
import org.buni.meldware.mail.mailhandler.localmailbox.LocalDeliveryMBean;
import org.buni.meldware.mail.message.EnvelopedAddress;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailRetryWrapper;
import org.buni.meldware.mail.message.Message;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

public class LocalDelivery
implements LocalDeliveryMBean,
Advised {
    private final Log log = Log.getLog(LocalDelivery.class);
    private MailboxService mailboxManager;
    private MessageDataUtil mdf;
    private MailListener router;
    private boolean isParseMime = true;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.mailhandler.localmailbox.LocalDelivery"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_deliver_N_2737389502385516318;
    private static WeakReference aop$MethodInfo_createMessage_N_4731347245706936481;

    public Message send(Message msg) throws MailException {
        if (msg == null) {
            return null;
        }
        this.log.info("Delivering message locally: %s", new Object[]{ArrayUtil.join(msg.getTo(), (String)",")});
        Mail smtpMessage = (Mail)msg;
        ArrayList<EnvelopedAddress> failed = new ArrayList<EnvelopedAddress>();
        MessageData md = this.createMessage(smtpMessage);
        for (MailAddress address : smtpMessage.getTo()) {
            EnvelopedAddress ea = new EnvelopedAddress(address);
            if (!ea.getLocal() || this.deliver(this.mailboxManager, address, md) >= 0) continue;
            failed.add(ea);
        }
        if (failed.size() > 0) {
            MailRetryWrapper mailWrp = smtpMessage instanceof MailRetryWrapper ? (MailRetryWrapper)smtpMessage : new MailRetryWrapper(smtpMessage, MailRetryWrapper.REDELIVERY_LOCAL);
            mailWrp.setTos(failed);
            this.router.send((Message)mailWrp);
        }
        return msg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Tx(value=TxType.REQUIRESNEW)
    private short org$buni$meldware$mail$mailhandler$localmailbox$LocalDelivery$deliver$aop(MailboxService manager, MailAddress address, MessageData message) {
        try {
            String user = address.getRawAddress();
            Mailbox mailbox = null;
            try {
                mailbox = manager.getMailboxByAlias(user);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                return 0;
            }
            catch (NoResultException noResultException) {
                return 0;
            }
            if (mailbox != null) {
                Folder inbox = mailbox.getDefaultInFolder();
                MessageData messageData = new MessageData(message);
                manager.createMail(inbox, messageData);
                return 1;
            }
            this.log.warn((Object)"Unknown user delivering to postmaster");
            Mailbox mbox = manager.getPostmasterMailbox();
            Folder inbox = mbox.getDefaultInFolder();
            MessageData mail = new MessageData(message);
            manager.createMail(inbox, mail);
            return 0;
        }
        catch (Exception e) {
            this.log.error((Throwable)e, (Object)"Could not deliver local mail");
            this.log.error((Object)("Unable to deliver message to local user: " + address.getRawAddress() + ".  Unknown user."));
            return -1;
        }
    }

    @Tx(value=TxType.REQUIRED)
    private MessageData org$buni$meldware$mail$mailhandler$localmailbox$LocalDelivery$createMessage$aop(Mail mail) {
        long t0 = System.currentTimeMillis();
        MessageData md = this.mdf.create(mail, this.isParseMime);
        long t1 = System.currentTimeMillis();
        this.log.info("Time to create message: %d", new Object[]{t1 - t0});
        return md;
    }

    public void setMailboxManager(MailboxService mailboxManager) {
        this.mailboxManager = mailboxManager;
        this.mdf = new MessageDataUtil(mailboxManager.getBodyManager());
    }

    public void setRouter(MailListener router) {
        this.router = router;
    }

    public void setParseMime(boolean isParseMime) {
        this.isParseMime = isParseMime;
    }

    public boolean getParseMime() {
        return this.isParseMime;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        LocalDelivery localDelivery = this;
        synchronized (localDelivery) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        LocalDelivery localDelivery = this;
        synchronized (localDelivery) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRESNEW)
    private short deliver(MailboxService mailboxService, MailAddress mailAddress, MessageData messageData) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deliver_N_2737389502385516318.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deliver_N2737389502385516318 deliver_N27373895023855163182 = new deliver_N2737389502385516318(methodInfo, interceptorArray);
            deliver_N27373895023855163182.arg0 = mailboxService;
            deliver_N27373895023855163182.arg1 = mailAddress;
            deliver_N27373895023855163182.arg2 = messageData;
            deliver_N27373895023855163182.setTargetObject(this);
            deliver_N27373895023855163182.typedTargetObject = this;
            deliver_N27373895023855163182.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Short)deliver_N27373895023855163182.invokeNext();
        }
        return this.org$buni$meldware$mail$mailhandler$localmailbox$LocalDelivery$deliver$aop(mailboxService, mailAddress, messageData);
    }

    @Tx(value=TxType.REQUIRED)
    private MessageData createMessage(Mail mail) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createMessage_N_4731347245706936481.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createMessage_N4731347245706936481 createMessage_N47313472457069364812 = new createMessage_N4731347245706936481(methodInfo, interceptorArray);
            createMessage_N47313472457069364812.arg0 = mail;
            createMessage_N47313472457069364812.setTargetObject(this);
            createMessage_N47313472457069364812.typedTargetObject = this;
            createMessage_N47313472457069364812.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageData)createMessage_N47313472457069364812.invokeNext();
        }
        return this.org$buni$meldware$mail$mailhandler$localmailbox$LocalDelivery$createMessage$aop(mail);
    }

    public static class deliver_N2737389502385516318
    extends MethodInvocation
    implements Untransformable {
        public MailboxService arg0;
        public MailAddress arg1;
        public MessageData arg2;
        public LocalDelivery typedTargetObject;

        public deliver_N2737389502385516318(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deliver_N2737389502385516318(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deliver_N2737389502385516318(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deliver_N2737389502385516318() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Short(this.typedTargetObject.org$buni$meldware$mail$mailhandler$localmailbox$LocalDelivery$deliver$aop(this.arg0, this.arg1, this.arg2));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MailboxService)object;
            Object object2 = objectArray[1];
            this.arg1 = (MailAddress)object2;
            Object object3 = objectArray[2];
            this.arg2 = (MessageData)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            deliver_N2737389502385516318 deliver_N27373895023855163182 = new deliver_N2737389502385516318(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deliver_N27373895023855163182.arguments = this.arguments;
            ((InvocationBase)deliver_N27373895023855163182).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deliver_N27373895023855163182).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deliver_N27373895023855163182).instanceResolver = ((InvocationBase)this).instanceResolver;
            deliver_N27373895023855163182.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deliver_N27373895023855163182).targetObject = ((InvocationBase)this).targetObject;
            deliver_N27373895023855163182.arg0 = this.arg0;
            deliver_N27373895023855163182.arg1 = this.arg1;
            deliver_N27373895023855163182.arg2 = this.arg2;
            return deliver_N27373895023855163182;
        }
    }

    public static class createMessage_N4731347245706936481
    extends MethodInvocation
    implements Untransformable {
        public Mail arg0;
        public LocalDelivery typedTargetObject;

        public createMessage_N4731347245706936481(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createMessage_N4731347245706936481(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createMessage_N4731347245706936481(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createMessage_N4731347245706936481() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailhandler$localmailbox$LocalDelivery$createMessage$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Mail)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            createMessage_N4731347245706936481 createMessage_N47313472457069364812 = new createMessage_N4731347245706936481(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createMessage_N47313472457069364812.arguments = this.arguments;
            ((InvocationBase)createMessage_N47313472457069364812).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createMessage_N47313472457069364812).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createMessage_N47313472457069364812).instanceResolver = ((InvocationBase)this).instanceResolver;
            createMessage_N47313472457069364812.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createMessage_N47313472457069364812).targetObject = ((InvocationBase)this).targetObject;
            createMessage_N47313472457069364812.arg0 = this.arg0;
            return createMessage_N47313472457069364812;
        }
    }
}

