/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.mail.internet.MailDateFormat;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.mailbox.PantoContentHandler;
import org.buni.meldware.mail.message.Body;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.MailHeaders;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.SimpleCopier;
import org.buni.panto.ContentHandler;
import org.buni.panto.MimeParser;

public class MessageDataUtil {
    private static final Log log = Log.getLog(MessageDataUtil.class);
    private final MailBodyManager mgr;
    private static final byte[] ENDL = new byte[]{13, 10};

    public MessageDataUtil(MailBodyManager mgr) {
        this.mgr = mgr;
    }

    public MessageData create(Mail mail, boolean parseMime) {
        MessageData md;
        try {
            MailDateFormat df = new MailDateFormat();
            MailHeaders headers = mail.getMailHeaders();
            String[] tsraw = headers.getHeader("Date");
            if (tsraw == null || tsraw.length == 0) {
                headers.addHeader("Date", df.format(new Date()));
            }
            if (parseMime && mail.isMime()) {
                InputStream is = mail.getRawStream(this.mgr);
                md = this.createMimeMessage(is);
                md.setHeaders(mail.getMailHeaders());
            } else {
                md = new MessageData(mail);
            }
        }
        catch (MailException e) {
            log.warn((Throwable)e, "Mime parse failed, building simple message: %s", new Object[]{e});
            md = new MessageData(mail);
        }
        catch (IOException e) {
            log.warn("Mime parse failed, building simple message: %s", new Object[]{e});
            md = new MessageData(mail);
        }
        return md;
    }

    public MessageData createMimeMessage(InputStream is) throws IOException {
        SimpleCopier c = new SimpleCopier();
        PantoContentHandler mch = new PantoContentHandler(this.mgr, c);
        MimeParser p = new MimeParser();
        p.setContentHandler((ContentHandler)mch);
        p.parse(is);
        MessageData md = mch.getMessage();
        this.setSizes(md);
        return md;
    }

    public void printMessage(MessageData message, boolean includeHeaders, OutputStream out, Copier copier) throws IOException {
        if (includeHeaders) {
            out.write(message.getHeader().getBytes());
            out.write(ENDL);
        }
        if (message.isMime()) {
            this.writeln(message.getMimePreamble(), out);
            String boundary = message.getBoundary();
            for (MessageBody body : message.getBody()) {
                out.write((String.valueOf(boundary) + "\r\n").getBytes("US-ASCII"));
                out.write(body.getMimeheader().getBytes("US-ASCII"));
                out.write(ENDL);
                this.printBodyPart(body, true, out, copier);
                if (body.hasChildren()) continue;
                out.write(ENDL);
            }
            out.write((String.valueOf(boundary) + "--" + "\r\n").getBytes("US-ASCII"));
            this.writeln(message.getEpilogue(), out);
        } else if (message.getBody().size() > 0) {
            this.mgr.write((Body)message.getBody().get(0), out, copier);
        } else {
            throw new MailException("Message has no body");
        }
    }

    public void printBodyPart(MessageBody body, boolean includeHeaders, OutputStream out, Copier c) throws IOException {
        String header = body.getHeader();
        if (header != null && header.length() > 0 && includeHeaders) {
            out.write(header.getBytes("US-ASCII"));
            out.write(ENDL);
        }
        switch (body.getType()) {
            case MULTIPART: {
                this.writeln(body.getPreamble(), out);
                for (MessageBody child : body.getChildren()) {
                    out.write(("--" + body.getBoundary() + "\r\n").getBytes("US-ASCII"));
                    out.write(child.getMimeheader().getBytes("US-ASCII"));
                    out.write(ENDL);
                    this.printBodyPart(child, true, out, c);
                    if (child.hasChildren()) continue;
                    out.write(ENDL);
                }
                out.write(("--" + body.getBoundary() + "--" + "\r\n").getBytes("US-ASCII"));
                this.writeln(body.getEpilogue(), out);
                break;
            }
            case MESSAGE: {
                int size = body.getChildren().size();
                if (size != 1) {
                    log.warn("Strange message simple text message with %d parts", new Object[]{size});
                }
                for (MessageBody child : body.getChildren()) {
                    this.printBodyPart(child, true, out, c);
                    out.write(ENDL);
                }
                break;
            }
            default: {
                Body b = this.mgr.createMailBody(new Long(body.getBodyId()));
                this.mgr.write(b, out, c);
            }
        }
    }

    private void writeln(String value, OutputStream out) throws IOException {
        if (value != null) {
            out.write(value.getBytes("US-ASCII"));
        }
        out.write(ENDL);
    }

    private void setSizes(MessageData md) {
        if (md.isMime()) {
            long size = 0L;
            size += (long)md.getHeader().length();
            size += (long)ENDL.length;
            size += (long)this.getLength(md.getMimePreamble());
            size += (long)ENDL.length;
            for (MessageBody mb : md.getBody()) {
                size += (long)md.getBoundary().length();
                size += (long)ENDL.length;
                String mh = mb.getMimeheader();
                long mimeHeaderSize = mh != null ? mh.length() + 2 : 2;
                size += mimeHeaderSize;
                this.setSizes(mb);
                if (!mb.hasChildren()) {
                    size += 2L;
                }
                size += mb.getPartSize();
            }
            size += (long)md.getBoundary().length();
            size += (long)"--".length();
            size += (long)ENDL.length;
            size += (long)this.getLength(md.getEpilogue());
            md.setSize(size += (long)ENDL.length);
        }
    }

    private void setSizes(MessageBody mb) {
        long size = 0L;
        String h = mb.getHeader();
        long headerSize = h != null && h.length() > 0 ? h.length() + 2 : 0;
        size += headerSize;
        switch (mb.getType()) {
            case MULTIPART: {
                size += (long)this.getLength(mb.getPreamble());
                size += (long)ENDL.length;
                for (MessageBody child : mb.getChildren()) {
                    size += (long)"--".length();
                    size += (long)mb.getBoundary().length();
                    size += (long)ENDL.length;
                    String mh = child.getMimeheader();
                    long mimeHeaderSize = mh != null ? mh.length() + 2 : 2;
                    size += mimeHeaderSize;
                    this.setSizes(child);
                    if (!child.hasChildren()) {
                        size += 2L;
                    }
                    size += child.getPartSize();
                }
                size += (long)"--".length();
                size += (long)mb.getBoundary().length();
                size += (long)"--".length();
                size += (long)ENDL.length;
                size += (long)this.getLength(mb.getEpilogue());
                mb.setPartSize(size += (long)ENDL.length);
                break;
            }
            case MESSAGE: {
                for (MessageBody child : mb.getChildren()) {
                    this.setSizes(child);
                    size += child.getPartSize();
                    size += (long)ENDL.length;
                }
                mb.setPartSize(size);
            }
        }
    }

    private int getLength(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }
}

