/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.util.ArrayList;
import java.util.Collection;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.api.FolderNotExistsException;
import org.buni.meldware.mail.mailbox.Alias;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.FolderProxy;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.mailbox.MailboxService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailboxProxy
implements org.buni.meldware.mail.api.Mailbox {
    private MailboxService service;
    private Mailbox mailbox;

    public MailboxProxy(MailboxService service, Mailbox mailbox) {
        this.service = service;
        this.mailbox = mailbox;
    }

    @Override
    public Collection<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (Alias alias : this.mailbox.getAliases()) {
            aliases.add(alias.getName());
        }
        return aliases;
    }

    @Override
    public org.buni.meldware.mail.api.Folder getDefault() {
        return new FolderProxy(this.service, this.mailbox.getDefaultInFolder());
    }

    @Override
    public org.buni.meldware.mail.api.Folder getFolder(String name) {
        Folder f = this.service.getSubfolderByName((Folder)this.mailbox, name);
        return new FolderProxy(this.service, f);
    }

    @Override
    public org.buni.meldware.mail.api.Folder getFolder(String[] path) {
        FolderProxy fp = null;
        Folder f = this.service.getSubfolderByPath((Folder)this.mailbox, path);
        if (f != null) {
            fp = new FolderProxy(this.service, f);
        }
        return fp;
    }

    @Override
    public org.buni.meldware.mail.api.Folder createFolder(String[] path) {
        Folder f = this.service.createFolder((Folder)this.mailbox, path);
        return new FolderProxy(this.service, f);
    }

    @Override
    public void deleteFolder(String[] path) {
        Folder toDelete = this.service.getSubfolderByPath((Folder)this.mailbox, path);
        if (toDelete == null) {
            String msg = String.format("Folder %s does not exist", ArrayUtil.join((Object[])path, (String)"/"));
            throw new FolderNotExistsException(msg);
        }
        this.service.deleteFolder(toDelete);
    }

    @Override
    public org.buni.meldware.mail.api.Folder getRootFolder() {
        return new FolderProxy(this.service, (Folder)this.mailbox);
    }
}

