/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.buni.meldware.mail.api.FolderBody;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.mailbox.FolderBodyProxy;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailHeaders;
import org.buni.meldware.mail.message.MailHeadersImpl;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.SimpleCopier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderMessageProxy
implements FolderMessage {
    private MailboxService service;
    private MessageData message;
    MailHeaders headers = null;

    public FolderMessageProxy(MailboxService service, MessageData message) {
        this.service = service;
        this.message = message;
    }

    @Override
    public long getFolderId() {
        return this.message.getFolder().getId();
    }

    @Override
    public int getUid() {
        return (int)this.message.getId();
    }

    @Override
    public boolean isAnswered() {
        return this.message.isAnswered();
    }

    @Override
    public boolean isDeleted() {
        return this.message.isDeleted();
    }

    @Override
    public boolean isFlagged() {
        return this.message.isFlagged();
    }

    @Override
    public boolean isRecent() {
        return this.message.isRecent();
    }

    @Override
    public boolean isSeen() {
        return this.message.isSeen();
    }

    @Override
    public List<FolderBody> getBody() {
        List<MessageBody> bodies = this.service.getMessageBody(this.message);
        ArrayList<FolderBody> result = new ArrayList<FolderBody>();
        for (MessageBody body : bodies) {
            result.add(new FolderBodyProxy(this.service, body));
        }
        return result;
    }

    @Override
    public String getMessageId() {
        return this.message.getMessageId();
    }

    @Override
    public MailAddress getSender() {
        return this.message.getSender();
    }

    @Override
    public long getSize() {
        return this.message.getSize();
    }

    @Override
    public String getSubject() {
        return this.message.getSubject();
    }

    @Override
    public List<MailAddress> getTo() {
        return this.message.getTo();
    }

    @Override
    public boolean isMime() {
        return this.message.isMime();
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    public void save() {
        this.service.updateMessageMetaData(this.message);
    }

    @Override
    public void write(OutputStream out, Copier copier) {
        this.service.mimePrintMessage(this.message.getId(), true, out, copier);
    }

    @Override
    public List<String> removeFlags(List<String> flags) {
        this.message.getFlagList().setFlags(false, flags);
        this.service.updateMessageMetaData(this.message);
        return this.message.getFlagList().getFlagList();
    }

    @Override
    public List<String> setFlags(boolean isReplace, List<String> flags) {
        if (isReplace) {
            this.message.getFlagList().setFlags(flags);
        } else {
            this.message.getFlagList().setFlags(true, flags);
        }
        this.service.updateMessageMetaData(this.message);
        return this.message.getFlagList().getFlagList();
    }

    @Override
    public String getFlagString() {
        return this.message.getFlagList().toFlagString();
    }

    @Override
    public String[] getHeaders() {
        return this.message.getHeaders();
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            this.headers = MailHeadersImpl.create((String[])this.message.getHeaders());
        }
        String[] values = this.headers.getHeader(name);
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    @Override
    public String[] getHeaders(String name) {
        String[] values;
        if (this.headers == null) {
            this.headers = MailHeadersImpl.create((String[])this.message.getHeaders());
        }
        if ((values = this.headers.getHeader(name)) == null) {
            values = new String[]{};
        }
        return values;
    }

    @Override
    public Date getTimestamp() {
        return this.message.getTimestamp();
    }

    @Override
    public boolean isSet(String flag) {
        return this.message.getFlagList().isSet(flag);
    }

    @Override
    public void print(OutputStream out) {
        this.service.mimePrintMessage(this.message.getId(), true, out, new SimpleCopier());
    }

    @Override
    public void print(OutputStream out, Copier copier) {
        this.service.mimePrintMessage(this.message.getId(), true, out, copier);
    }

    @Override
    public void printText(OutputStream out) {
        this.service.mimePrintMessage(this.message.getId(), false, out, new SimpleCopier());
    }

    @Override
    public void printText(OutputStream out, Copier copier) {
        this.service.mimePrintMessage(this.message.getId(), false, out, copier);
    }

    @Override
    public long getHeaderSize() {
        return this.message.getHeader().length();
    }

    @Override
    public long getBodySize() {
        return this.message.getSize() - (long)(this.message.getHeader().length() + 2);
    }

    @Override
    public FolderBody getBodyPart(int i) {
        MessageBody body = this.service.getMessageBody(this.message, i);
        FolderBodyProxy result = null;
        if (body != null) {
            result = new FolderBodyProxy(this.service, body);
        }
        return result;
    }

    @Override
    public FolderBody getBodyPart(int[] address) {
        FolderBodyProxy result = null;
        if (address.length == 0) {
            throw new IllegalArgumentException("address.length == 0");
        }
        MessageBody bodyPart = this.service.getMessageBody(this.message, address[0]);
        int i = 1;
        while (i < address.length && bodyPart != null) {
            bodyPart = this.service.getMessageBody(bodyPart, address[i]);
            ++i;
        }
        if (bodyPart != null) {
            result = new FolderBodyProxy(this.service, bodyPart);
        }
        return result;
    }

    @Override
    public boolean isMessage() {
        return true;
    }
}

