/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.OutputStream;
import org.buni.meldware.mail.api.FolderBody;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.SimpleCopier;

public class FolderBodyProxy
implements FolderBody {
    private MailboxService service;
    private MessageBody body;

    public FolderBodyProxy(MailboxService service, MessageBody body) {
        this.service = service;
        this.body = body;
    }

    public long getSize() throws StoreException {
        return this.body.getSize();
    }

    public Long getStoreId() throws StoreException {
        return this.body.getStoreId();
    }

    public void setSize(int size) {
    }

    public String getMimeheader() {
        return this.body.getMimeheader();
    }

    public String[] getHeaders() {
        String[] headers = null;
        String header = this.body.getHeader();
        if (header != null) {
            headers = header.split("\r\n");
        }
        return headers;
    }

    public boolean isMessage() {
        return this.body.getHeader() != null && this.body.getHeader().length() > 0;
    }

    public boolean isMime() {
        return this.body.getMimeheader() != null;
    }

    public boolean hasContent() {
        return !this.body.getBodyless();
    }

    public void print(OutputStream out, Copier copier) {
        this.service.mimePrintBody(this.body.getId(), true, out, copier);
    }

    public void print(OutputStream out) {
        this.printText(out, new SimpleCopier());
    }

    public void printText(OutputStream out, Copier copier) {
        this.service.mimePrintBody(this.body.getId(), false, out, copier);
    }

    public void printText(OutputStream out) {
        this.printText(out, new SimpleCopier());
    }

    public FolderBody getBodyPart(int i) {
        FolderBodyProxy result = null;
        MessageBody bodyPart = this.service.getMessageBody(this.body, i);
        if (bodyPart != null) {
            result = new FolderBodyProxy(this.service, bodyPart);
        }
        return result;
    }

    public long getBodySize() {
        return this.body.getPartSize() - (long)(this.getHeaderSize() + 2);
    }

    public int getHeaderSize() {
        String header = this.body.getHeader();
        if (header == null) {
            return 0;
        }
        return header.length();
    }
}

