/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.util.List;
import java.util.regex.Pattern;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.api.FolderBody;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.commands.fetch.SearchPart;
import org.buni.meldware.mail.message.Body;

public class StringArgSearchPart
extends SearchPart {
    String argument;
    private IMAP4ProtocolInstance protocolInstance;

    public boolean includes(FolderMessage msg) {
        if (this.getType().equals("BCC")) {
            return this.handleHeader(msg, "Bcc");
        }
        if (this.getType().equals("BODY")) {
            return this.handleBody(msg);
        }
        if (this.getType().equals("CC")) {
            return this.handleHeader(msg, "Cc");
        }
        if (this.getType().equals("FROM")) {
            return this.handleHeader(msg, "From");
        }
        if (this.getType().equals("KEYWORD")) {
            return this.handleFlag(msg, true);
        }
        if (this.getType().equals("SUBJECT")) {
            return this.handleHeader(msg, "Subject");
        }
        if (this.getType().equals("TEXT")) {
            return this.handleBody(msg);
        }
        if (this.getType().equals("TO")) {
            return this.handleHeader(msg, "To");
        }
        if (this.getType().equals("UNKEYWORD")) {
            return this.handleFlag(msg, false);
        }
        return false;
    }

    protected boolean handleFlag(FolderMessage msg, boolean set) {
        String flags = msg.getFlagString().toLowerCase();
        if (set) {
            return flags.indexOf(this.getArgument().toLowerCase()) >= 0;
        }
        return flags.indexOf(this.getArgument().toLowerCase()) < 0;
    }

    public void setProtocolInstance(IMAP4ProtocolInstance protocolInstance) {
        this.protocolInstance = protocolInstance;
    }

    protected boolean handleBody(FolderMessage msg) {
        Pattern.compile(this.getArgument(), 18);
        List<FolderBody> bodies = msg.getBody();
        int limit = bodies.size();
        int k = 0;
        if (k < limit) {
            Body cfr_ignored_0 = bodies.get(k);
            throw new MailException("Implement Body Searching!!!");
        }
        return false;
    }

    protected boolean handleHeader(FolderMessage msg, String header) {
        throw new RuntimeException("TODO IMPLEMENT");
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public String getArgument() {
        return this.argument;
    }
}

