/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.io.IOException;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.commands.fetch.MessagePropertyPart;

public class RFC822PartRequest
extends MessagePropertyPart {
    private static final String NAME = "RFC822";
    String _type = "";

    public String getType() {
        return this._type;
    }

    public RFC822PartRequest(String type) {
        super(NAME);
        this._type = type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void fetch(FolderMessage msg, IMAP4OutputStream out) {
        try {
            out.write(this.getName());
            out.write(".");
            out.write(this.getType());
            out.write(" ");
        }
        catch (IOException e) {
            throw new StreamWriteException(e);
        }
        if (!"SIZE".equals(this._type)) {
            if ("HEADER".equals(this._type)) {
                throw new MailException("Implement RFC822.HEADER");
            }
            if ("TEXT".equals(this._type)) {
                throw new MailException("Implement RFC822.TEXT");
            }
            if ("BODY".equals(this._type)) {
                throw new MailException("Implement RFC822.BODY");
            }
            throw new MailException("Unknown fetch command %s.%s", this.getName(), this.getType());
        }
        this.fetchSize(msg, out);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        if (!this._type.equals("")) {
            result.append("." + this._type);
        }
        return result.toString();
    }
}

